/**
 * activities.js
 */

/**
 * Interfaz para controlar todas las actividades
 */
var baseActivity = {
    respuestas_correctas: 0,
    respuestas_incorrectas: 0,
    total_preguntas: 0,
    actividades: [],
    actividad_actual: 0,
    // Número total de actividades
    num_actividades: 0,
    tiempo_total: 0,
    /**
     * Inicializar las actividades de la página actual
     *
     * @param activity Ruta al JSON que define las actividades de la página
     */
    init: function(activity) {
        // Reiniciamos las variables de la actividad
        this.restart();

        // Modificamos texto para habilitar sistema de traducción manual
        // ! En caso de no estar definido se salta la traducción
        if (typeof $ehabilis_custom_texts !== 'undefined') {
            $('button.submit.boton.btnCorreccion').html(
                $ehabilis_custom_texts.custom_text_idevice_msg_other_1);
            $('button.reiniciar.boton.btnCorreccion').html(
                $ehabilis_custom_texts.custom_text_idevice_msg_other_2);
            $('form.cloze-form input.button[type=submit]').attr(
                'value', $ehabilis_custom_texts.custom_text_idevice_msg_other_3);
        }

        // Borramos toda la salida
        $('#salida').html('');

        // Obtenemos la configuración de la actividad
        $.getJSON(activity, function (content) {
            // Obtenemos el número de actividades
            baseActivity.num_actividades = content.actividades.length;

            // ??
            if (content["cuaderno"] != undefined && content["cuaderno"] == "true") {
                $(".lateral-pdf").hide();
            }

            // Obtenemos todas las actividades
            for (var i = 0; i < baseActivity.num_actividades; i++) {
                baseActivity.actividades[i] = content.actividades[i];
            }

            // Si se ha cargado alguna actividad la ejecutamos
            if (baseActivity.num_actividades > 0) {
                baseActivity.loadActivity(baseActivity.actividades[baseActivity.actividad_actual]);
            // En caso contrario lanzamos un error
            } else {
                console.log("[ERROR] No se han encontrado actividades, comprueba que el JSON está bien formado.");
                return;
            }

            // Botón de comprobar
            $(".submit").on('click', function (event) {
                event.preventDefault();
                baseActivity.check();
            });

            // Botón de mostrar solución
            $(".solucion").on('click', function (a) {
                a.preventDefault();
                baseActivity.solucionar();
            });

            // Botón para ir a la siguiente actividad
            $(".siguiente").hide();
            $(".siguiente").click(function (a) {
                a.preventDefault();
                baseActivity.siguiente();
            });

            // ??
            $(".lateral-botonera").height($(".escena").height() - 160);

        });
    },
    /**
     * Reiniciar las variables internas a sus valores por defecto
     */
    restart: function () {
        this.respuestas_correctas = 0;
        this.respuestas_incorrectas = 0;
        this.total_preguntas = 0;
        this.actividades = [];
        this.actividad_actual = 0;
        this.num_actividades = 0;
        this.tiempo_total = 0;
        // TODO: Habría que reiniciar la actividad también
    },
    /**
     * Comprobar la solución dada por el usuario
     */
    check: function () {
        // Comprobamos si es la última actividad
        // TODO: Nunca va a pasar aquí, ¿no?
        // El primero es un índice y el segundo un contador
        if (baseActivity.actividad_actual == baseActivity.num_actividades) {
            // Calculamos la puntuación
            var score = parseInt(10 * baseActivity.respuestas_correctas / baseActivity.total_preguntas);

            // Calculamos el tiempo
            // TODO: Reimplementar esto (¿Por qué se quitó?)
            tiempo = parseInt((fechaF.getTime() - fechaI.getTime()) / 1000);

            // Cambiamos el enunciado a Fin de la actividad (Esto no pasa)
            $("#enunciado").text("Fin de la actividad");
            // Y borramos la actividad (Esto no pasa)
            $("#salida").empty();

            // Mostramos la puntuación y el tiempo
            // $(".feedback").text("Has obtenido una puntación de "+score+" sobre 10. Tiempo de realización: "+baseActivity.tiempo_total+" segundos.");
            // $(".feedback").show();

            // Reproducimos el sonido de finalización de la actividad (Esto no pasa)
            var audio = new Audio('media/lesson_complete.mp3');
            audio.play();

            // Ocultamos los botones de Solucionar y Ir a la siguiente actividad
            $(".solucion").hide();
            $(".siguiente").hide();

            // Esto es para enviar los datos a SCORM, pero ni está bien ni lo hace
            var pagina = window.location.hash.replace('#pagina/', '');
            $.getJSON('json_recursos/indice.json', function (json) {
                if (json[parseInt(pagina)][0].scorm == 'si') {
                    console.log(score);
                    LMS_init();
                    LMS_set("cmi.core.score.min", 0);
                    LMS_set("cmi.core.score.max", 10);
                    LMS_set("cmi.core.score.raw", score * 10);
                    LMS_set("cmi.core.score.scaled", score);
                    LMS_set("cmi.suspend_data", 1);
                    LMS_set("cmi.core.lesson_status", "completed");
                    LMS_complete();
                    LMS_end();
                };
            });
        // Si tenemos más actividades
        } else {
            // Obtenemos los resultados de la propia actividad
            var result = null;
            try {
                result = baseActivity.execute(baseActivity.actividad_actual, "check");
            } catch (err) {
                result = baseActivity.execute(baseActivity.actividad_actual, "comprobar");
            }

            baseActivity.respuestas_correctas += result.correct;
            baseActivity.respuestas_incorrectas = result.wrong;
            baseActivity.total_preguntas += result.total;
            baseActivity.tiempo_total += result.time;

            // Añadir texto al feedback y mostrarlo (TODO: Decidir si se quiere esto (opcional quizás?))
            // $(".feedback").text(result.feedbacks).show();

            // Mostramos el botón siguiente
            // TODO: Preparar las actividades para que pueda haber varias (o eliminar este código)
            // $('.siguiente').show();

            // TODO: Enviar los datos al LMS (o LRS en caso de TinCan)
            // LMS_show("Enviando datos actividad");
            // LMS_set("cmi.score.min",0);
            // LMS_set("cmi.score.max",10);
            // LMS_set("cmi.score.raw",score);
            // LMS_set("cmi.score.scaled",score/10);
            // LMS_set("cmi.suspend_data",1);
            // LMS_set("cmi.completion_status","completed");
            // LMS_complete();
            // LMS_end();
            // LMS_show("Fin del envío");
            // Enviamos la puntuación a kitaboo
            // sendDataToKitaboo(score, 10, "");

            // Forzamos el evento resize para adaptarnos al nuevo contenido
            $(window).trigger('resize');
        }
    },
    /**
     * Mostrar la solución correcta de la actividad
     * TODO: Esto no se usa (decidir si se quiere usar o eliminar)
     */
    solve: function () {
        // TODO: Porqué se guarda en una variable si no se usa?
        var solucion = baseActivity.execute(baseActivity.actividad_actual, "solve");

        $(window).trigger('resize');
    },
    /**
     * Navegar a la siguiente actividad
     */
    siguiente: function () {
        //Incrementamos para ir a la actividad siguiente
        baseActivity.actividad_actual++;

        // Si es la última actividad, mostramos la pantalla de resultados
        if (baseActivity.actividad_actual == baseActivity.num_actividades) {
            baseActivity.comprobar();
        // Si no es la última
        } else {
            // Limpiamos la salida y el Feedback
            $("#salida").empty();
            $(".feedback").hide();

            // Y ejecutamos la baseActivity
            baseActivity.execute(baseActivity.actividad_actual, "iniciar", "contenido_actividades/" + baseActivity.actividades[baseActivity.actividad_actual].contenido);

            // Ocultamos los botones de Reiniciar, Mostrar Solución y Siguiente
            $(".reiniciar").hide();
            $(".solucion").hide();
            $(".siguiente").hide();
            // Mostramos el botón de Corregir
            $(".submit").show();
        }

    },
    /**
     * Ejecutar un método de la actividad
     */
    execute: function (actividad, metodo, params) {
        // Otra vez lo mismo. Actividades no debería poder ser nunca un objeto (siempre un Array)
        let result = null;
        try {
            result = window[baseActivity.actividades[actividad].recurso][metodo](params);
        } catch (err) {
            result = window[baseActivity.actividades[0].recurso][metodo](params);
        }
        return result;
    },
    /**
     * Listado de actividades con sus scripts asociados
     */
    activityList: {
        // Actividad "Rellenar los huecos"
        'rellenar': 'js/activities/fill.js',
        'relacionar': 'js/activities/link.js',
        'test': 'js/activities/test.js',
        'clasificar_desde_texto': 'js/activities/clasify.js',
        'vf_multirespuesta': 'js/activities/multichoice.js',
        'drag_drop_image': 'js/activities/image_map.js',
        'test_and_text': 'js/activities/text_test.js',
        'select': 'js/activities/select_word.js',
        'escribir_parte': 'js/activities/write_word.js',
        'sort': 'js/activities/sort.js',
        'comillas': 'js/activities/quotes.js'
    },
    /**
     * Función que inicializa una actividad (además de cargar el script asociado a la misma)
     *
     * @param activity Objeto que contiene todos los datos de la actividad
     */
    loadActivity: function(activity) {
        if(!(activity.recurso in this.activityList)) {
            console.log('La actividad "' + activity.recurso + '" no tiene ningún script asociado.');
            return;
        }

        // TODO: Usar algo como cachedScript (https://api.jquery.com/jquery.getscript/#caching-requests)
        $.getScript(this.activityList[activity.recurso], function(data, textStatus, jqxhr) {
            baseActivity.execute(baseActivity.actividad_actual, "init", "contenido_actividades/" + baseActivity.actividades[baseActivity.actividad_actual].contenido);
        }).fail(function(jqxhr, settings, exception) {
            console.log('No se ha podido cargar el script de la actividad.');
        });
    }
}
