// TODO: Esta debería ser una actividad como las demás

// Variables globales
var cardScore = {
    correct: 0,
    wrong: 0,
    reset: function() {
        this.correct = 0;
        this.wrong = 0;
    },
    getTotal: function() {
        return this.correct + this.wrong;
    }
};

// Audios
var audioSuccess = new Audio('media/acierto.mp3');
var audioFailure = new Audio('media/fallo.mp3');

// Asociamos los eventos
$(document).ajaxStop(initCardGame);
$(document).on('ready', initCardGame);

function initCardGame() {
    // Reiniciamos los contadores
    cardScore.reset();

    // Textos botones acierto/fallo
    $('.btn.btn-default.pull-right.acierto').html($ehabilis_custom_texts.custom_text_idevice_msg_card_9);
    $('.btn.btn-default.pull-left.fallo').html($ehabilis_custom_texts.custom_text_idevice_msg_card_10);

    // Activamos la funcionalidad flip con click como trigger
    $(".f1_container").not(".targresul").flip({ trigger: "click" });

    $('.f1_container .acierto, .f1_container .fallo').on('click', function(e) {
        e.preventDefault();

        if($(this).hasClass('acierto')) {
            // Sumamos el acierto al contador
            cardScore.correct++;

            // Establecemos a acertado el círculo correspondiente a esta tarjeta
            $(".indicador li.circulo:nth-child(" + (cardScore.getTotal()) + ")").addClass("acertado");

            // Reproducimos el sonido
            audioSuccess.play();
        } else {
            // Sumamos el acierto al contador
            cardScore.wrong++;

            // Establecemos a acertado el círculo correspondiente a esta tarjeta
            $(".indicador li.circulo:nth-child(" + (cardScore.getTotal()) + ")").addClass("fallado");

            // Reproducimos el sonido
            audioFailure.play();
        }

        // Ocultamos esta tarjeta
        // TODO: Deberíamos usar $.hide()?
        $(this).parents('.f1_container').addClass('oculto');

        // Obtenemos la siguiente carta (en caso de que exista)
        var nextCard = $(this).parents('.f1_container').next('.f1_container:not(.targresul)');
        // Si hay siguiente carta la mostramos
        if(nextCard.length > 0) {
            nextCard.removeClass('oculto');
        // Si no la hay significa que hemos llegado al final
        } else {
            // Mostramos la tarjeta de resultados
            $('.targresul').removeClass("oculto");

            // Si has respondido a todas bien
            if (cardScore.wrong == 0) {
                // Añadimos la frase del resultado
                $('.resultado').html(
                    "<h4 class='titulo_inter'>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_3+"</h4>"
                    + "<p class='frase_inter'>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_4+"</p>");
                // Cambiamos el título de la modal
                $('.modal-title').html("</br>");
                // Cambiamos el subtítulo de la modal
                $('.sus').html(" ");
            // Si has respondido bien menos del 20 %
            } else if(cardScore.correct <= (cardScore.getTotal() * (20 / 100))) {
                // Añadimos la frase del resultado
                $('.resultado').html(
                    "<h4 class='titulo_inter'>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_5+"</h4>"
                    + "<p class='frase_inter'>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_6+"</p>");
                // Cambiamos el título de la modal
                $('.modal-title').html("<br/>");
                // Cambiamos el subtítulo de la modal
                $('.sus').html(" ");
            } else {
                // Añadimos los resultados
                $('.resultado').html(
                    "<strong>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_11+": </strong> "
                    + cardScore.correct
                    + "</br><strong>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_12+": </strong>"
                    + cardScore.wrong);
                // Cambiamos el título de la modal
                $('.modal-title').html("<h4>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_7+"</h4>");
                // Cambiamos el subtítulo de la modal
                $('.sus').html("<p>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_8+"</p>");
            }
        }
    });

    // Botón de cerrar la ventana modal
    // TODO: Cambiar el ID de la modal (pierde los estilos)
    $('#myModal').on('hidden.bs.modal', function () {
        // Ocultamos todo menos la primera tarjeta
        $('.targresul').addClass("oculto");
        $('.f1_container').addClass('oculto').first().removeClass('oculto');

        // Reseteamos las puntuaciones
        cardScore.reset();

        // Quitamos los colores de los círculos
        $(".indicador li.circulo").removeClass("acertado fallado");

        // Ponemos el título y el subtítulo a los valores por defecto
        $('.modal-title').html($ehabilis_custom_texts.custom_text_idevice_msg_card_1);
        $('.sus').html("<p>"+$ehabilis_custom_texts.custom_text_idevice_msg_card_2+"</p>");

        var cards = $(".f1_container").not(".targresul");

        // Volteamos las cartas a su posicion original
        cards.find('.front').css({ 'transform': 'rotatey(0deg)' });
        cards.find('.back').css({ 'transform': 'rotatey(-180deg)' });

        // Marcamos la carta como volteada (fliped) con el calor "false"
        cards.data("fliped", false);

        // Para ajustar el tamaño del iframe una vez cerrada la ventana modal
        $(window).trigger('resize');
    });
}
