/**
 * Actividad "Clasificar palabras"
 */
var clasificar_desde_texto = {
    // Variables internas de la actividad
    types: [],
    words: [],
    text: '',
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.types = [];
        this.words = [];
        this.text = '';
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     * 
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // TODO: esto debería llamar a una función de "rellenar" para poder usar "this"
        $.getJSON(json_path, function(activity) {
            // Descodificamos el contenido de la actividad
            // y lo guardamos en el objeto de la actividad
            for(var i = 0; i < activity.palabras.length; i++) {
                clasificar_desde_texto.words[i] = activity.palabras[i];
            }
            for(var i = 0; i < activity.tipos.length; i++) {
                clasificar_desde_texto.types[i] = activity.tipos[i];
            }

            clasificar_desde_texto.text = base64.decode(activity.texto);

            // Obtenemos los datos básicos de la actividad
            clasificar_desde_texto.title = activity.titulo;
            clasificar_desde_texto.statement = activity.enunciado;
            clasificar_desde_texto.icon = activity.icono;
            clasificar_desde_texto.code = activity.codigo;
            // TODO: El problema de hacer esto así es que si hay más contenido en la página
            // el tiempo que el usuario está viendo el resto del contenido también cuenta
            clasificar_desde_texto.startDate = new Date();

            // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
            $("#titular").text(clasificar_desde_texto.title);
            $("#enunciado").text(clasificar_desde_texto.statement);
            
            // Añadimos el bloque de frases y la tabla vacíos
            $("#salida").html('<div class="divContenedor">' +
                '<div class="bloqueFrases">' +
                    '<div class="textos"></div>' +
                '</div>' +
                '<div class="bloqueTable"></div>' +
            '</div>');
            
            $("#salida").addClass('clasify-activity');

            // Convertimos el texto en un array
            var split_text = clasificar_desde_texto.text.split('<>');
            if((split_text.length - 1) != clasificar_desde_texto.words.length) {
                console.log("[ERROR] clasify.js | El fichero JSON de la actividad no tiene el mismo número de huecos y letras (" + json_path + ").");
                return;
            }

            // Añadimos el texto al contenedor
            for (var i = 0; i < (split_text.length - 1); i++) {
                $('.bloqueFrases .textos').append(split_text[i]);
                $('.bloqueFrases .textos').append(
                    '<div class="palabrasClasificarDesdeTexto" id="p' + i + '">' +
                        base64.decode(clasificar_desde_texto.words[i].palabra) +
                    '</div>'
                );
            }
            $('.bloqueFrases .textos').append(split_text[(split_text.length - 1)]);

            // TODO: Meter todo en una única tabla y eliminar el número
            var htmlTabla = '';
            var id = 0;
            for(var i = 0; i < clasificar_desde_texto.types.length; i++) {
                htmlTabla += '<table class="table2">';
                htmlTabla += '<tr>' +
                    '<th>' +
                        base64.decode(clasificar_desde_texto.types[i].nombre_tipo) +
                    '</th>' +
                '</tr>';

                var max_num = base64.decode(clasificar_desde_texto.types[i].numero);
                for(var n = 0; n < max_num; n++) {
                    htmlTabla += '<tr>' +
                        '<td>' +
                            '<div class="wrapClasificarDesdeTexto" id="' + base64.decode(clasificar_desde_texto.types[i].nombre_tipo)+ '_' + id + '">' +
                                '<div class="contenedorCajaClasificarDesdeTexto">' +
                                    '<div class="caja">&nbsp;</div>' +
                                '</div>' +
                            '</div>' +
                        '</td>' +
                    '</tr>';

                    id++;
                }
                htmlTabla += '</table>';
            }

            $(".bloqueTable").append(htmlTabla);

            // Desordenamos las respuestas
            // TODO: Tal vez sería mejor reordenar las palabras antes de añadirlas al HTML
            // para evitar modificar el DOM sin motivo
            // TODO: Habría que añadir una opción para esto
            // $(".palabras").shuffle();
    
            // Ocultamos el botón de reiniciar y mostramos el de corregir
            $(".reiniciar").hide();
            $(".submit").show();

            // Inicializamos los cajones de las palabras como elemento draggable
            $(".palabrasClasificarDesdeTexto").draggable({
                revert: true,
                revertDuration: 400,
                zIndex: 1000
            });

             // Inicializamos los cajones dentro de las tablas como contenedores
            $(".contenedorCajaClasificarDesdeTexto").droppable({
                activeClass: "uiClasificarDesdeTexto -state-default",
                hoverClass: "resaltado",
                drop: function (event, ui) {
                    var wordId = ui.draggable.attr("id").slice(1);

                    $(this).attr("id", "f" + wordId);
                    $(this).prepend(
                        ui.draggable.text().trim() +
                        '<a id="' + wordId + '" href="javascript:void(0);" class="eliminar" title="Eliminar">' +
                            '<img src="img/null.gif" width="16" height="16" alt="Eliminar" />' +
                            '<i class="fa fa-times"></i>' +
                        '</a>'
                    );
                    
                    // Ocultamos el cajón desplazable
                    ui.draggable.css('visibility', 'hidden');
                    // E impedimos que se pueda volver a dejar una palabra en este cajón
                    $(this).droppable({
                        disabled: true
                    });
                }
            });

            // Quitamos el anterior listener para evitar que el código se ejecute varias veces
            $(".bloqueTable").off('click');

            // Listener para cuando se hace click en el botón eliminar
            $(".bloqueTable").on("click", ".eliminar", function() {
                // Obtenemos el contenedor
                var container = $(this).parents('.contenedorCajaClasificarDesdeTexto');
                // Obtenemos el ID
                var wordId = $(container).attr("id").slice(1);

                $('#p' + wordId).css('visibility', 'visible');

                // Hacemos que se puedan volver a soltar palabras en este contenedor
                $(container).droppable({
                    disabled: false
                });
                
                // Borramos el contenido y el ID del contenedor
                $(container).html("&nbsp;");
                $(container).removeAttr('id');
            });

            // Mostramos la actividad
            $('.activity-content').show();
            // Y redimensionamos la pantalla
            $(window).trigger('resize');
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            clasificar_desde_texto.init(e.data.json_path);
        });
    },
    check: function() {
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            // TODO: Esto podría no ser exacto
            total: $(".wrapClasificarDesdeTexto").length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        // Ocultamos los botones de eliminar
        $(".eliminar").hide();
        // Ocultamos los contenedores de las palabras
        $(".bloqueFrases").hide();
        
        // Obtenemos el número de aciertos
        for (var i = 0; i < $(".wrapClasificarDesdeTexto").length; i++) {
            // Con esta linea obtenemos el tipo de la tabla en la que esta el elemento
            var tipo_tabla = $($(".wrapClasificarDesdeTexto").get(i)).attr("id").split('_')[0];
            var id = $($(".wrapClasificarDesdeTexto").get(i)).children('.contenedorCajaClasificarDesdeTexto').attr("id");
            console.log(id);

            if(id != null && id != 'undefined') {
                console.log(base64.decode(clasificar_desde_texto.words[id.slice(1)].tipo).toLowerCase());
                console.log(tipo_tabla.toLowerCase());
                if(base64.decode(clasificar_desde_texto.words[id.slice(1)].tipo).toLowerCase() == tipo_tabla.toLowerCase()) {
                    $('#' + id).parents('.wrapClasificarDesdeTexto').addClass("comillas2");
                    $('#' + id).prepend('<i class="fa fa-check feed_correcto"></i>');
                    result.correct++;
                } else {
                    $('#' + id).parents('.wrapClasificarDesdeTexto').addClass("comillas2");
                    $('#' + id).prepend('<i class="fa fa-times feed_incorrecto"></i>');
                    result.wrong++;
                }
            }
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        // Ocultamos el botón de eliminar de las palabras
        $(".eliminar").hide();
        
        // Ocultamos las frases para arrastrar (TODO: Buena idea??)
        $(".bloqueFrases").hide();

        // Borramos la tabla
        $(".bloqueTable").empty();

        var htmlTabla = '';
        var id = 0;
        var num_palabras = clasificar_desde_texto.words.length;
        var num_tipos = clasificar_desde_texto.types.length;

        for(var i = 0; i < num_tipos; i++) {
            htmlTabla += '<table class="table2">';
            htmlTabla += '<tr><th>' + base64.decode(clasificar_desde_texto.types[i].nombre_tipo) + '</th></tr>';

            for(var item = 0; item < num_palabras; item++) {
                if(base64.decode(clasificar_desde_texto.words[item].tipo).toLowerCase() == base64.decode(clasificar_desde_texto.types[i].nombre_tipo).toLowerCase()) {
                    htmlTabla += '<tr><td>' + base64.decode(clasificar_desde_texto.words[item].palabra) + '</td></tr>';
                }
            }
            htmlTabla += '</table>';
        }

        $(".bloqueTable").append(htmlTabla);
    }
}
