/**
 * Actividad "Rellenar los huecos"
 */
var rellenar = {
    // Variables internas de la actividad
    letters: [],
    words: [],
    sentences: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.letters = [];
        this.words = [];
        this.sentences = [];
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     *
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // TODO: esto debería llamar a una función de "rellenar" para poder usar "this"
        $.getJSON(json_path, function(activity) {
            if (activity.letras.length != activity.palabras.length || activity.letras.length != activity.frases.length) {
                console.log("[ERROR] fill.js | El fichero JSON de la actividad no tiene el mismo número de letras, frases y palabras (" + json_path + ").");
                return;
            }

            // Descodificamos el contenido de la actividad
            // y lo guardamos en el objeto de la actividad
            for (var i = 0; i < activity.letras.length; i++) {
                rellenar.letters[i] = base64.decode(activity.letras[i]);
                rellenar.words[i] = base64.decode(activity.palabras[i]);
                rellenar.sentences[i] = base64.decode(activity.frases[i]);
            }

            // Obtenemos los datos básicos de la actividad
            rellenar.title = activity.titulo;
            rellenar.statement = activity.enunciado;
            rellenar.icon = activity.icono;
            rellenar.code = activity.codigo;
            // TODO: El problema de hacer esto así es que si hay más contenido en la página
            // el tiempo que el usuario está viendo el resto del contenido también cuenta
            rellenar.startDate = new Date();

            // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
            $("#titular").text(rellenar.title);
            $("#enunciado").html(rellenar.statement);

            // Se añade icono ayuda
            if ($ehabilis_custom_texts.custom_text_idevice_fill_msg_help) {
                $("#enunciado").append('<div class="fill-activity-help-icon"></div>');
                $("#enunciado .fill-activity-help-icon").on("click", function() {
                    if ($(".fill-activity-help-text").hasClass('hidden')){
                        $(".fill-activity-help-text").removeClass('hidden');
                    } else {
                        $(".fill-activity-help-text").addClass('hidden');
                    }
                })
            }

            // TODO: Reañadir iconos?
            //$("#icono").attr("src", "icons/" + rellenar.icon + ".png");

            // Añadimos el bloque de frases vacío
            $("#salida").html('<div class="bloqueFrases"></div>');

            // Añadimos una clase específica
            $('#salida').addClass('fill-activity');

            // Añadimos las frases al contenedor
            for (var i = 0; i < rellenar.words.length; i++) {
                var frase = rellenar.sentences[i].replace(
                '<>',
                '<div class="contenedorCaja"><div class="caja">&nbsp;</div></div>');

                // Añadimos la frase y la palabra al HTML
                $(".bloqueFrases").append(
                    '<div class="linea">' +
                        '<div class="wrap" id="w' + i + '">' +
                            '<span class="numero">' + rellenar.letters[i] + '</span>' +
                            '<div class="inner-text">' + frase + '</div>' +
                        '</div>' +
                        '<div class="div-palabra">' +
                            '<div class="palabras" id="p' + i + '">' + rellenar.words[i] + '</div>' +
                        '</div>' +
                    '</div>');
            }

            // Desordenamos las respuestas
            // TODO: Tal vez sería mejor reordenar las palabras antes de añadirlas al HTML
            // para evitar modificar el DOM sin motivo
            $(".palabras").shuffle();

            // Ocultamos el botón de reiniciar y mostramos el de corregir
            $(".reiniciar").hide();
            $(".submit").show();

            // Inicializamos los cajones de las palabras como elemento draggable
            $(".palabras").draggable({
                revert: true,
                revertDuration: 400,
                zIndex: 1000,
                drag: function(e) {
                    // Si la posición del elemento en la pantalla es menor, se mueve el scroll hacia arriba
                    if (e.originalEvent.screenY < 300) {
                        rellenar.scrollActivity(-3);
                    }
                    // Si la posición del elemento es mayor que la altura de la pantalla, se mueve el scroll hacia abajo
                    if (e.originalEvent.screenY > $(window.parent).height()) {
                        rellenar.scrollActivity(3);
                    }
                }
            });

            // Inicializamos los cajones dentro de las frases como contenedores
            $(".contenedorCaja").droppable({
                activeClass: "ui-state-default",
                hoverClass: "resaltado",
                drop: function (event, ui) {
                    var sentenceId = $(this).parents('.wrap').attr("id").slice(1);
                    var wordId = ui.draggable.attr("id").slice(1);

                    // Establecemos el ID
                    $(this).attr('id', 'f' + wordId);
                    // Añadimos el texto y el botón de eliminar
                    $(this).prepend(
                        ui.draggable.text().trim()
                        + '<a id="' + wordId + '" href="javascript:void(0);" class="eliminar" title="Eliminar">'
                        + '<img src="img/null.gif" width="16" height="16" alt="Eliminar" class="icono icono_borrar" />'
                        + '</a>');

                    // Ocultamos el cajón desplazable
                    ui.draggable.hide();
                    // E impedimos que se pueda volver a dejar una palabra en este cajón
                    $(this).droppable({
                        disabled: true
                    });
                }
            });

            // Quitamos el anterior listener para evitar que el código se ejecute varias veces
            $(".bloqueFrases").off('click');

            // Listener para cuando se hace click en el botón eliminar
            $(".bloqueFrases").on("click", ".eliminar", function() {
                // Obtenemos el contenedor
                var container = $(this).parents('.contenedorCaja').first();
                // Obtenemos el ID y la palabra que está escrita
                var wordId = $(this).attr('id');
                var word = $(container).text().trim();

                $("#p" + wordId).text(word);
                $("#p" + wordId).show();

                // Hacemos que se puedan volver a soltar palabras en este contenedor
                $(container).droppable({
                    disabled: false
                });

                // Borramos el contenido y el ID del contenedor
                $(container).html("&nbsp;");
                $(container).removeAttr('id');
            });

            // Mostramos la actividad
            $('.activity-content').show();
            // Y redimensionamos la pantalla
            $(window).trigger('resize');
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            rellenar.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: $(".wrap").length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        // Ocultamos los botones de eliminar
        $(".eliminar").hide();
        // Ocultamos los contenedores de las palabras
        $(".palabras").hide();

        // Obtenemos el número de aciertos
        for (var i = 0; i < $(".wrap").length; i++) {
            // Si no se ha respondido lo ignoramos
            if ($('#f' + i).length > 0) {
                // Si es correcto
                if ($("#f" + i).parents('.wrap').attr("id").slice(1) == i) {
                    $("#f" + i).parents('.wrap').addClass("correcto");
                    $("#f" + i).prepend('<i class="fa fa-check feed_correcto"></i>');
                    $("#f" + i).parents('.wrap').append('<div class="feedback-lateral">' + random_acierto() + '</div>');
                    result.correct++;
                // Si es incorrecto
                } else {
                    $("#f" + i).parents('.wrap').addClass("incorrecto");
                    $("#f" + i).prepend('<i class="fa fa-times feed_incorrecto"></i>');
                    // Nota: Descomentar esto si se quiere que aparezcan mensajes de error
                    // TODO: Adaptar el diseño y hacer opcional
                    // $("#f" + i).parents('.wrap').append('<div class="feedback-lateral">' + random_fallos() + '</div>');
                    result.wrong++;
                }
            }
        }

        // Calculamos la puntuación (parseInt para obtener solo la parte entera)
        result.score = parseInt(10 * result.correct / $(".wrap").length);
        // Componemos el feedback
        result.feedback = 'Has acertado ' + result.correct + ' palabras. Tiempo de realización: ' + result.time + 'segundos.';

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        // Ocultamos el botón de eliminar de las palabras
        $(".eliminar").hide();

        // Ocultamos las palabras para arrastrar
        $(".palabras").hide();

        // Borramos todo lo que contiene el contenedor de la actividad
        $("#salida .bloqueFrases").empty();

        // Añadimos las frases con las palabras correctas
        for (var i = 0; i < rellenar.words.length; i++) {
            var frase = rellenar.sentences[i].replace('<>','<div class="contenedorCaja"><div class="caja">' + rellenar.words[i] + '</div></div>');

            $(".bloqueFrases").append(
                '<div class="wrap" id="w' + i + '">' +
                    '<span class="numero">' + rellenar.letters[i] + '</span>' +
                    frase +
                '</div>'
            );
        }
    },
    /**
     * Función que hace scroll al deslizar las palabras
    */

    scrollActivity: function(step) {
        var scrollY = $(window.parent).scrollTop();
        $(window.parent).scrollTop(scrollY + step);
    }
}
