/**
 * Actividad "Relacionar conceptos e imágenes"
 */
var drag_drop_image = {
    // Variables internas de la actividad
    solutions: [],
    words: [],
    coordinates: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.solutions = [];
        this.coordenadas_arr2 = [];
        this.words = [];
        this.coordinates = [],
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     * 
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // Lo hacemos por AJAX y no getJSON para poder usar la propiedad context
        // y así poder usar this dentro del callback
        $.ajax({
            dataType: "json",
            url: json_path,
            success: this.parseActivityJson,
            context: this
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            drag_drop_image.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: this.solutions.length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        // Ocultamos los botones de eliminar
        $(".eliminar").hide();
        // Ocultamos los contenedores de las palabras
        $("#palabras").hide();
        
        for (var i = 0; i < this.solutions.length; i++) {
            if( this.solutions[i][0] == this.solutions[i][1]) {
                $("#p" + i).prepend('<i class="fa fa-check feed_correcto"></i>');
                result.correct++;
            } else {
                $("#p" + i).prepend('<i class="fa fa-times feed_incorrecto"></i>');
                result.wrong++;
            }
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".solucion").hide();
        $(".submit").hide();

        // Añadimos las palabras correctas a los contenedores
        for (var i = 0; i < this.words.length; i++) {
            $("#p" + i).hide();
            $("#g" + (i + 1)).prepend('<li>' + base64.decode(this.words[i]) + '</li>');
        }
    },
    /**
     * Parsea el JSON de la actividad y lo guarda en el objeto JS de la misma
     * 
     * @param activity El JSON obtenido para la actividad
     */
    parseActivityJson: function(activity) {
        // Descodificamos el contenido de la actividad
        // y lo guardamos en el objeto de la actividad
        for(var i = 0; i < activity.palabras.length; i++) {
            this.words[i] = base64.decode(activity.palabras[i]);
        }

        // Obtenemos los datos básicos de la actividad
        this.coordinates = activity.coordenadas.split(" ");
        this.title = activity.titulo;
        this.statement = activity.enunciado;
        this.icon = activity.icono;
        this.code = activity.codigo;
        // TODO: El problema de hacer esto así es que si hay más contenido en la página
        // el tiempo que el usuario está viendo el resto del contenido también cuenta
        this.startDate = new Date();

        // Escribimos la actividad en pantalla
        this.draw();

        // Inicializamos los cajones de las palabras como elemento draggable
        $("#palabras ul li").draggable({
            revert: true,
            revertDuration: 400,
            zIndex: 1000
        });

        // Inicializamos los cajones encima de la imagen como contenedores
        $(".diana ul").droppable({
            activeClass: "ui-state-default",
            hoverClass: "ui-state-hover",
            drop: function (event, ui) {
                var containerId = $(this).parent().attr("id").slice(1);
                var wordId = ui.draggable.attr("id").slice(1);
        
                // Guardamos la solución dada por el usuario
                drag_drop_image.solutions[wordId][0] = containerId;

                // TODO: Averiguar para que es esto (por si la palabra ocupa varias líneas??)
                $(this).parent().css("height", "");
                // Añadimos el botón de eliminar
                $(this).prepend(
                    '<li id="p' + wordId + '">' +
                        ui.draggable.text() +
                        '<a id="p' + wordId + '" href="javascript:void(0);" class="eliminar" title="Eliminar">' +
                            '<img src="img/null.gif" width="16" height="16" alt="Eliminar" class="icono icono_borrar" />' +
                        '</a>' +
                    '</li>'
                );
                
                // Ocultamos la palabra
                ui.draggable.css('visibility', 'hidden');

                // Y deshabilitamos el cajón
                $(this).droppable({
                    disabled: true
                })
            }
        });
    
        // Quitamos el anterior listener para evitar que el código se ejecute varias veces
        $("#salida").off("click");

        // Listener para cuando se hace click en el botón eliminar
        $("#salida").on("click", ".eliminar", function() {
            var wordId = $(this).attr("id").slice(1);

            // ??	
            $(this).parents('.diana').css("height", "34px");
            // Eliminamos la palabra del contenedor
            $(".ui-droppable #p" + wordId).remove();
    
            console.log("#g" + drag_drop_image.solutions[wordId][0] + " ul");

            // Volvemos a activar el cajón
            $("#g" + drag_drop_image.solutions[wordId][0] + " ul").droppable({
                disabled: false
            });

            // Borramos la solución guardad
            drag_drop_image.solutions[wordId][0] = 0;

            // Y volvemos a mostrar la palabra
            $("#palabras ul li#p" + wordId).css('visibility', 'visible');
        });

        // Mostramos la actividad
        $('.activity-content').show();
        // Y redimensionamos la pantalla
        $(window).trigger('resize');
    },
    /**
     * Escribe la actividad al HTML de la página
     */
    draw: function() {
        // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
        $("#titular").text(this.title);
        $("#enunciado").text(this.statement);

        // Añadimos el bloque de respuestas vacío
        $("#salida").html(
            '<div class="grafico"></div>' +
            '<div id="palabras">' +
                '<ul class="lista bloquePal"></ul>' +
            '</div>'
        );
    
        // Añadimos las palabras
        for (var i = 0; i < this.words.length; i++) {
            // Guardamos la solución
            // Siempre es 0 porque no hay nigún resultado asociado
            this.solutions[i] = [0, i + 1];
            this.coordinates[i] = this.coordinates[i].split(".");

            // Añadimos la palabra a la lista
            $("#palabras ul").append(
                '<li id="p' + i + '" class="elemPal">' +
                    this.words[i] +
                "</li>"
            );

            // Y el cuadro a la imagen
            // TODO: Los estilos del cuadro (aparte de left y right claro) deben ir en el CSS
            $(".grafico").append(
                '<div id="g' + (i + 1) + '" class="diana" style="left:' + this.coordinates[i][0] + "px; top:" + this.coordinates[i][1] + 'px; width:207px; min-height:34px;border:1px solid #AAA;">' +
                    '<ul></ul>' +
                '</div>'
            );
        }
            
        // Desordenamos las respuestas
        // TODO: Tal vez sería mejor reordenar las palabras antes de añadirlas al HTML
        // para evitar modificar el DOM sin motivo
        $(".elemPal").shuffle();
    
        // Añadimos la imagen
        // TODO: Esto debería ser configurable usando el JSON (incluído el alt)
        $(".grafico").append('<img src="media/imagenes_actividades/mapa.jpg" alt="ERROR"/>');
    
        // Ocultamos el botón de reiniciar y mostramos el de corregir
        $(".reiniciar").hide();
        $(".submit").show();
    }
}
