/**
 * Actividad "Relacionar palabras con imágenes"
 */
var relacionar = {
    letters: [],
    words: [],
    images: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para resetear los valores de las variables internas de la actividad
     */
    reset: function() {
        this.letters = [];
        this.words = [];
        this.images = [];
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     *
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // TODO: esto debería llamar a una función de "relacionar" para poder usar "this"
        $.getJSON(json_path, function(activity) {
            if (activity.letras.length != activity.palabras.length || activity.letras.length != activity.imaxes.length) {
                console.log("[ERROR] link.js | El fichero JSON de la actividad no tiene el mismo número de letras, frases y palabras (" + json_path + ").");
                return;
            }

            // Descodificamos el contenido de la actividad
            // y lo guardamos en el objeto de la actividad
            for (var i = 0; i < activity.letras.length; i++) {
                relacionar.letters[i] = base64.decode(activity.letras[i]);
                relacionar.words[i] = base64.decode(activity.palabras[i]);
                relacionar.images[i] = activity.imaxes[i];
            }

            // Obtenemos los datos básicos de la actividad
            relacionar.title = activity.titulo;
            relacionar.statement = activity.enunciado;
            relacionar.icon = activity.icono;
            relacionar.code = activity.codigo;
            // TODO: El problema de hacer esto así es que si hay más contenido en la página
            // el tiempo que el usuario está viendo el resto del contenido también cuenta
            relacionar.startDate = new Date();

            // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
            $("#titular").text(relacionar.title);
            $("#enunciado").text(relacionar.statement);

            // TODO: Reañadir iconos?
            // $("#icono").attr("src", "icons/" + relacionar.icon + ".png");

            // Añadimos el bloque de frases vacío
            $("#salida").html('<div class="bloqueFrases"></div>');

            // Añadimos una clase específica
            $("#salida").addClass('link-activity');


            for (var i = 0; i < relacionar.words.length; i++) {
                // Añadimos la imagen y la palabra al HTML
                $(".bloqueFrases").append(
                    '<div class="linea">' +
                        '<div class="wrap" id="w' + i + '">' +
                            '<span class="numero">' + relacionar.letters[i] + '</span>' +
                            // TODO: El ancho y la altura no se deberían controlar aquí
                            '<p><img src="' + relacionar.images[i] + '" width="70" alt="Imagen relacionar"/></p>' +
                            '<div class="contenedorCaja">' +
                                '<div class="caja">&nbsp;</div>' +
                            '</div>' +
                        '</div>' +
                        '<div class="div-palabra">' +
                            '<div class="palabras" id="p' + i + '">' + relacionar.words[i] + '</div>' +
                        '</div>' +
                    '</div>'
                );
            }

            // Desordenamos las respuestas
            // TODO: Tal vez sería mejor reordenar las palabras antes de añadirlas al HTML
            // para evitar modificar el DOM sin motivo
            $(".palabras").shuffle();

            // Ocultamos el botón de reiniciar y mostramos el de corregir
            $(".reiniciar").hide();
            $(".submit").show();

            // Inicializamos los cajones de las palabras como elemento draggable
            $(".palabras").draggable({
                revert: true,
                revertDuration: 400,
                zIndex: 1000
            });

            // Inicializamos los cajones debajo de las imágenes como contenedores
            $(".contenedorCaja").droppable({
                activeClass: "ui-state-default",
                hoverClass: "resaltado",
                drop: function (event, ui) {
                    var imageId = $(this).parents('.wrap').attr("id").slice(1);
                    var wordId = ui.draggable.attr("id").slice(1);

                    // Establecemos el ID
                    $(this).attr("id", "f" + wordId);
                    // Añadimos el texto y el botón de eliminar
                    $(this).prepend(
                        ui.draggable.text().trim() +
                        '<a id="' + wordId + '" href="javascript:void(0);" class="eliminar" title="Eliminar">' +
                            '<img src="img/null.gif" width="16" height="16" alt="Eliminar" class="icono icono_borrar" />' +
                        '</a>'
                    );

                    // Ocultamos el cajón desplazable
                    ui.draggable.hide();
                    // E impedimos que se pueda volver a dejar una palabra en este cajón
                    $(this).droppable({
                        disabled: true
                    });
                }
            });

            // Quitamos el anterior listener para evitar que el código se ejecute varias veces
            $(".bloqueFrases").off('click');

            // Listener para cuando se hace click en el botón eliminar
            $(".bloqueFrases").on("click", ".eliminar", function() {
                // Obtenemos el contenedor
                var container = $(this).parents('.contenedorCaja').first();
                // Obtenemos el ID y la palabra que está escrita
                var wordId = $(this).attr('id');
                var word = $(container).text().trim();

                $("#p" + wordId).text(word);
                $("#p" + wordId).show();

                // Hacemos que se puedan volver a soltar palabras en este contenedor
                $(container).droppable({
                    disabled: false
                });

                // Borramos el contenido y el ID del contenedor
                $(container).html("&nbsp;");
                $(container).removeAttr('id');
            });

            // Mostramos la actividad
            $('.activity-content').show();
            // Y redimensionamos la pantalla
            $(window).trigger('resize');
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            relacionar.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: $(".wrap").length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        // Mostramos el botón de Mostrar solución
        // $(".solucion").show();

        // Ocultamos los botones de eliminar
        $(".eliminar").hide();

        // Ocultamos los contenedores de las palabras
        $(".palabras").hide();

        // Obtenemos el número de aciertos
        result.correct = 0;
        for (var i = 0; i < $(".wrap").length; i++) {
            // Si no se ha respondido lo ignoramos
            if ($('#f' + i).length > 0) {
                // Si es correcto
                if ($("#f" + i).parents('.wrap').attr("id").slice(1) == i) {
                    $("#f" + i).parents('.wrap').addClass("correcto");
                    $("#f" + i).prepend('<i class="fa fa-check feed_correcto"></i>');
                    $("#f" + i).parents('.wrap').append('<div class="feedback-lateral">' + random_acierto() + '</div>');
                    result.correct++;
                // Si es incorrecto
                } else {
                    $("#f" + i).parents('.wrap').addClass("incorrecto");
                    $("#f" + i).prepend('<i class="fa fa-times feed_incorrecto"></i>');
                    // Nota: Descomentar esto si se quiere que aparezcan mensajes de error
                    // TODO: Adaptar el diseño y hacer opcional
                    // $("#f" + i).parents('.wrap').append('<div class="feedback-lateral">' + random_fallo() + '</div>');
                    result.wrong++;
                }
            }
        }

        // Calculamos la puntuación (parseInt para obtener solo la parte entera)
        result.score = parseInt(10 * result.correct / $(".wrap").length);
        // Componemos el feedback
        result.feedback = 'Has acertado ' + result.correct + ' palabras. Tiempo de realización: ' + result.time + 'segundos.';

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        // Ocultamos el botón de eliminar de las palabras
        $(".eliminar").hide();

        // Ocultamos las palabras para arrastrar
        $(".palabras").hide();

        // Borramos todo lo que contiene el contenedor de la actividad
        $("#salida .bloqueFrases").empty();

        /*var palabras_length = relacionar.palabras.length;
        for (var i = 0; i < palabras_length; i++){
            $("#f"+i).text(relacionar.palabras[i]);

        }*/

        // Añadimos las frases con las palabras correctas
        for (var i = 0; i < relacionar.words.length; i++) {
            $(".bloqueFrases").append(
                '<div class="wrap wrap_2lineasRelacionar" id="w' + i + '">' +
                    '<div class="contenido">' +
                        '<span class="numero">' + relacionar.letters[i] + '</span>' +
                        '<p class="texto_2lineasRelacionar">' + relacionar.images[i] + '</p>' +
                    '</div>' +
                    '<div class="palabras" id="p' + i + '">&nbsp;</div>' +
                    '<div class="contenedorCaja">' +
                        '<div class="caja">' + relacionar.words[i] + '</div>' +
                    '</div>' +
                '</div>'
            );
        }
    }
}
