/**
 * Actividad "Test multirespuesta"
 */
var vf_multirespuesta = {
    // Variables internas de la actividad
    letters: [],
    solutions: [],
    elements: [],
    title: '',
    subtitle: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.letters = [];
        this.solutions = [];
        this.elements = [];
        this.title = '';
        this.subtitle = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     *
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // Lo hacemos por AJAX y no getJSON para poder usar la propiedad context
        // y así poder usar this dentro del callback
        $.ajax({
            dataType: "json",
            url: json_path,
            success: this.parseActivityJson,
            context: this
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            vf_multirespuesta.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: 0,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        // Obtenemos el número de aciertos
        var id = 0;
        for(sol = 0; sol < this.solutions.length; sol++) {
            // Contamos cuantas soluciones hai
            if(this.solutions[sol] == 1) {
                result.total++;
            }

            var check = $("#q" + sol);
            check.attr("disabled", true);

            if(check.is(':checked') && this.solutions[sol] == 1) {
                $("#q" + sol).parent().find('p').last().append('<i class="fa fa-check feed_correcto"></i>');
                $("#q" + sol).parent().append('<div class="flotante">' + random_acierto() + '</div>');
                $("#q" + sol).parents('li').removeClass('activo');
                $("#q" + sol).parents('li').addClass('correcta');

                result.correct++;
            } else if (check.is(':checked') && this.solutions[sol] == 0) {
                $("#q" + sol).parent().find('p').last().append('<i class="fa fa-times feed_incorrecto"></i>');
                // Descomentar esto si se quiere un mensaje de fallo
                // $("#q" + sol).parent().append('<div class="flotante">' + random_fallo() + '</div>');
                $("#q" + sol).parents('li').removeClass('activo');
                $("#q" + sol).parents('li').addClass('incorrecta');

                result.wrong++;
            }
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".solucion").hide();
        $(".submit").hide();

        // Escribimos la actividad en pantalla
        this.draw();

        // Recorremos todas las soluciones
        for(i = 0; i < this.solutions.length; i++) {
            // Obtenemos el check
            var check = $("#q" + i);

            // Si es una de las soluciones correctas lo marcamos como tal
            if(this.solutions[i] == 1) {
                check.wrap("<img src='img/circle.png' alt=''/>");
            }

            // Deshabilitamos el check
            check.attr("disabled", true);
        }
    },
    /**
     * Parsea el JSON de la actividad y lo guarda en el objeto JS de la misma
     *
     * @param activity El JSON obtenido para la actividad
     */
    parseActivityJson: function(activity) {
        // Descodificamos el contenido de la actividad
        // y lo guardamos en el objeto de la actividad
        for(var i = 0; i < activity.letras.length; i++) {
            this.letters[i] = base64.decode(activity.letras[i]);
            this.solutions[i] = base64.decode(activity.soluciones[i]);
            this.elements[i] = base64.decode(activity.elementos[i]);
        }

        // Obtenemos los datos básicos de la actividad
        this.title = activity.titulo;
        this.subtitle = activity.subtitulo;
        this.statement = activity.enunciado;
        this.code = activity.codigo;
        this.icon = activity.icono;
        // TODO: El problema de hacer esto así es que si hay más contenido en la página
        // el tiempo que el usuario está viendo el resto del contenido también cuenta
        this.startDate = new Date();

        // Escribimos la actividad en pantalla
        this.draw();

        // Nunca debería estar puesto este evento, ya que hasta
        // ahora no existían los checkboxes, pero por si acaso
        $('.chkRespuesta').off('change');
        $('.chkRespuesta').on('change', function (e) {
            $(this).parents('li').toggleClass('activo');
        });

        // Mostramos la actividad
        $('.activity-content').show();
        // Y redimensionamos la pantalla
        $(window).trigger('resize');
    },
    /**
     * Escribe la actividad al HTML de la página
     */
    draw: function() {
        // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
        $("#titular").text(this.title);
        $("#enunciado").html('<p>'+this.statement+'</p>');
        $('#subtitulo').text(this.subtitle);

        // Se añade icono ayuda
        if ($ehabilis_custom_texts.custom_text_idevice_multichoice_msg_help) {
            $("#enunciado").append('<div class="multichoice-activity-help-icon"></div>');
            $("#enunciado .multichoice-activity-help-icon").on("click", function() {
                if ($(".multichoice-activity-help-text").hasClass('hidden')){
                    $(".multichoice-activity-help-text").removeClass('hidden');
                } else {
                    $(".multichoice-activity-help-text").addClass('hidden');
                }
            })
        }

        // Añadimos el bloque de respuestas vacío
        $("#salida").html('<ol id="cuestionario"></ol>');

        // Le añadimos una clase específica
        $("#salida").addClass('multichoice-activity');

        // Metemos las preguntas
        for (i = 0; i < this.elements.length; i++) {
            $("#cuestionario").append(
                '<li class="question">' +
                    '<label>' +
                        '<input type="checkbox" class="chkRespuesta" name="q' + i + '" id="q' + i + '" />' +
                        '<p class="texto_2lineasVF">' +
                            this.elements[i] +
                        '</p>' +
                    '</label>' +
                '</li>'
            );
        }

        // Ocultamos el botón de reiniciar y mostramos el de corregir
        $(".reiniciar").hide();
        $(".submit").show();
    }
}
