/**
 *  Se inicializan las variables del cuestionario* 
 * 
 */

function initQuizTestScorm()
{
    // Permite seleccionar las respuestas del cuestionario
    var answer = document.querySelectorAll('.iDevice_answer');  
    var i=0;  
    for (i = 0; i < answer.length; i++) {  
        answer[i].addEventListener('click', function(){ 
            var elem = this.firstElementChild.lastElementChild; 
            var quizInput = document.querySelectorAll('input[name='+elem.name+']'); 
            var j = 0;  
            for (j = 0; j < quizInput.length; j++) {  
                quizInput[j].checked = false;  
                let parent = quizInput[j].parentNode.parentNode;  
                if(parent.classList.contains('activo')){  
                    parent.classList.remove('activo');  
                }  
            }  
            elem.checked = true;  
            this.classList.add('activo');  
        }); 
    } 

    // Si no se cumple la condición del cuestionario Scorm, se bloquean los botones de "Siguiente"
    lockLinksToProgressInPill();
    
}

/**
 *  Añade clase a los enlaces (botones de siguiente) y al botón de finalizar para bloquearlos o no según las condiciones
 *  del cuestionario  
 */

function lockLinksToProgressInPill(){
    // Comprueba si existe el campo para las condiciones
    var isMeetProgressInput = document.querySelectorAll('.meet-progress-condition-class');

    if(isMeetProgressInput.length > 0){    
        // Añade o no clase a los enlaces para avanzar en la pílora según la condición del cuestionario           
        changeStatusLinks();

        // Si hay un cuestionario en la última página, no se permite pulsar en finalizar hasta que se cumpla la condición            
        let finishButton = document.querySelector('.finish-button');
        if(finishButton){            
            changeStatusElement(finishButton);            
        }
        let finishButtonLink = document.querySelector('.finish-button-link');
        if(finishButtonLink){            
            changeStatusElement(finishButtonLink);            
        }

    }
}

/**
 *  Recorre cada uno de los elementos indicados para añadirles o la clase que los bloquea
 */
function changeStatusLinks(){

    var classes = ['.next-button-link', '.next-button-menu-link', '.finish-button-link', '.finish-button'];

    classes.forEach(function(elemClass){
        let element = document.querySelector(elemClass);
        if(element){   
            changeStatusElement(element);
        }
    });    
}

/**
 *  Comprueba si se cumple la condición del cuestionario y añade o elimina la clase al elemento indicado
 * 
 * @param {*} element 
 */
function changeStatusElement(element){
    if(checkConditionToAdvance()){
        element.classList.remove('deactivate-link');
    }
    else{
        if(!element.classList.contains('deactivate-link')){
            element.classList.add('deactivate-link');
        }
    }
}

/**
 * Comprueba si se cumple la condición del cuestionario
 * Devuelve verdadero si se cumple y falso en caso contrario
 * 
 * @returns boolean
 */
function checkConditionToAdvance(){
    // Devuelve los elementos (en este caso input del tipo "hidden") que indican si se cumple la condición
    var isMeetProgressInput = document.querySelectorAll('.meet-progress-condition-class');
    var avanceInPill = true;

    if(isMeetProgressInput){
        let i;        
        // Si hay algún elemento tiene el "value" a falso, ya no se cumplen todas las condiciones
        // Se comprueba por si hay más de un cuestionario en la misma página
        for(i = 0; i < isMeetProgressInput.length; i++){
            let idQuiz = isMeetProgressInput[i].getAttribute('data-id');
            let indexAttempted = -1;

            var typeQuiz = document.querySelector('#progresscondition-' + idQuiz);

            // Se busca si hay algun intento guardado del cuestionario actual
            if(attemptedQuizScorm.length > 0){
                indexAttempted = attemptedQuizScorm.findIndex(e => e.id === idQuiz);           
            }

            // Si el campo que indica la condición está a false y no hay ningún intento, no se puede avanzar
            if(isMeetProgressInput[i].value == 'false' && indexAttempted == -1){
                avanceInPill = false
            }
            // Si hay intentos y es necesario aprobar el cuestionario para continuar, se revisan si ha aprobado algun intento
            else if(indexAttempted > -1){
                avanceInPill = false;

                if(typeQuiz.value == 'passed'
                    || typeQuiz.value == 'completed'
                ){
                    // Si es el intento actual, se comprueba si la puntuación es superior o igual a la definida
                    if((actualScore >= scoreToPass
                        && typeQuiz.value == 'passed')
                        || (
                            questionsAnswered == numQuestions
                            && typeQuiz.value == 'completed'
                        )
                    ){
                        avanceInPill = true;
                    }// Si se accede de nuevo al cuestionario, se comprueba si ya ha hecho un intento y ha aprobado, puede continuar
                    else{
                        attemptedQuizScorm.forEach(function(element){
                            // Se comprueba que el intento se corresponda con el cuestionario
                            if(element.id == idQuiz
                               &&((element.score >= scoreToPass
                                && typeQuiz.value == 'passed')
                                || (typeQuiz.value == 'completed'
                                    && element.completed)
                               )
                            ){
                                avanceInPill = true;
                            }
                            
                        });
                    }
                }
                
            }
        }
    }

    return avanceInPill;
}