/**
 * Actividad "Comillas"
 */
var comillas = {
    // Variables internas de la actividad
    text: '',
    questions: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    solution: [],
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.text = '';
        this.questions = '';
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.solution = [];
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     * 
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function (json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // Lo hacemos por AJAX y no getJSON para poder usar la propiedad context
        // y así poder usar this dentro del callback
        $.ajax({
            dataType: "json",
            url: json_path,
            success: this.parseActivityJson,
            context: this
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            comillas.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
		this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: this.solution.length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

		// Mostramos el botón de reiniciar y ocultamos el de comprobar
		$(".reiniciar").show();
        $(".submit").hide();

        // Quitamos el listener del evento click para las comillas
        $(".comillas2").off("click");

        // Recorremos todos los elementos y cada una de las pregunas
        for(var i = 0; i < this.solution.length; i++) {
            var id_ca = $("#ca_" + i);
            
            // comprueba el color que tiene para saber si esta selecionado o no
            if (id_ca.css('color') == 'rgb(0, 127, 188)' && this.solution[i] == 1) {
                id_ca.append('<i class="fa fa-check feed_correcto "></i>');
                result.correct++;
            } else if(id_ca.css('color') == 'rgb(184, 184, 184)' && this.solution[i] == 0) {
                id_ca.append('<i class="fa fa-check feed_correcto"></i>');
                result.correct++;
            } else {
                result.wrong++;
                id_ca.append('<i class="fa fa-times feed_incorrecto"></i>');
            }
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');
        
        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
       // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        for(var i = 0; i < this.solution.length; i++) {
            var id_ca = $("#ca_" + i);
            var id_cc = $("#cc_" + i);

            // Marcamos solo si es correcta
            if (this.solution[i] == 1) {
                id_ca.css('color', 'rgb(0, 0, 255)');
                id_cc.css('color', 'rgb(0, 0, 255)');
            } else {
                id_ca.css('color', 'rgb(255, 250, 229)');
                id_cc.css('color', 'rgb(255, 250, 229)');
            }
        }

    },
    /**
     * Parsea el JSON de la actividad y lo guarda en el objeto JS de la misma
     * 
     * @param activity El JSON obtenido para la actividad
     */
    parseActivityJson: function(activity) {
        // Descodificamos el contenido de la actividad
        // y lo guardamos en el objeto de la actividad
        for(var i = 0; i < activity.solucion.length; i++) {
            this.solution[i] = base64.decode(activity.solucion[i]);
        }
        this.text = '<div class="textos">' + base64.decode(activity.texto) + '</div>';

        // Obtenemos los datos básicos de la actividad
        this.title = activity.titulo;
        this.statement = activity.enunciado;
        this.icon = activity.icono;
        this.code = activity.codigo;
        // TODO: El problema de hacer esto así es que si hay más contenido en la página
        // el tiempo que el usuario está viendo el resto del contenido también cuenta
        this.startDate = new Date();

        // Escribimos la actividad en pantalla
        this.draw();

        // Evento click en las comillas
        $(".comillas2").off('click');
        $(".comillas2").on('click', function (e) {
            var value_id = $(this).attr('id').slice(2);

            var id_ca = $("#ca" + value_id);
            var id_cc = $("#cc" + value_id);

            if (id_ca.css('color') == 'rgb(0, 127, 188)' && id_cc.css('color') == 'rgb(0, 127, 188)'){
                id_ca.css('color','rgb(184, 184, 184)');
                id_cc.css('color','rgb(184, 184, 184)');
            }else if(id_ca.css('color') == 'rgb(184, 184, 184)' && id_cc.css('color') == 'rgb(184, 184, 184)'){
                id_ca.css('color','rgb(0, 127, 188)');
                id_cc.css('color','rgb(0, 127, 188)');
            }

        });

        // Mostramos la actividad
		$('.activity-content').show();
		// Y redimensionamos la pantalla
		$(window).trigger('resize');
    },
    /**
     * Escribe la actividad al HTML de la página
     */
    draw: function() {
        // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
        $("#titular").text(this.title);
        $("#enunciado").text(this.statement);

        // Añadimos el bloque de respuestas vacío
        $("#salida").html('<div id="container"></div>');

        $(".reiniciar").hide();
            
        // Aquí vamos a generar la botonera, los textos y las preguntas
        var html = '';
        var split_text = this.text.split('<||>');

        for(var i = 0 ; i < (split_text.length - 1); i++) {
            split_text[i] = split_text[i].replace(">||<", '</span><span class = "comillas2 cerrar_comilla" id="cc_' + (i - 1) + '">»</span>');
            html += split_text[i] + '<span class = "comillas2 abrir_comilla" id="ca_' + i + '">«</span><span class = "comillas2 select_text" id="tx_' + i + '">';
        }

        // Introducimos la ultima linea
        split_text[(split_text.length - 1)] = split_text[(split_text.length - 1)].replace(">||<", '</span><span class = "comillas2 cerrar_comilla" id="cc_' + (split_text.length - 2) + '">»</span>');
        html += split_text[(split_text.length - 1)];

        $("#container").append(html);

        // Ocultamos el botón de reiniciar y mostramos el de corregir
		$(".reiniciar").hide();
		$(".submit").show();
    }
}
