/**
 * Actividad "Seleccionar palabra correcta"
 */
var select = {
    // Variables internas de la actividad
    letters: [],
    solutions: [],
    elements: [],
    options: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.letters = [];
        this.solutions = [];
        this.elements = [];
        this.options = [];
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     * 
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // Lo hacemos por AJAX y no getJSON para poder usar la propiedad context
        // y así poder usar this dentro del callback
        $.ajax({
            dataType: "json",
            url: json_path,
            success: this.parseActivityJson,
            context: this
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            select.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {	   
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: this.solutions.length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        var id = 0;
        // Recorremos todos los elementos y cada una de las pregunas
        for (i = 0; i < this.elements.length; i++) {
            for (o = 0; o < this.elements[i].options.length; o++) {
                // Deshabilitamos los select
                $("#p" + id).attr('disabled', true);
                
                // Comprobamos si la respuesta es correcta
                if ($("#p" + id).val() == this.elements[i].options[o][this.solutions[id]]) {
                    $("#p" + id).addClass("dianasSelect_correcta");
                    $("#rp" + id).prepend('<i class="fa fa-check feed_correcto"></i>');
                    result.correct++;
                }
                else{
                    //Esta linea marca de rojo las incorrectas
                    $("#p" + id).addClass("dianasSelect_incorrecta");
                    $("#rp" + id).prepend('<i class="fa fa-times feed_incorrecto"></i>');
                    result.wrong++;
                }
        
                id++;
            }
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        var id = 0;
        for (i = 0; i < this.elements.length; i++) {
            for(o = 0; o < this.elements[i].options.length; o++) {
                $("#p" + id).val(this.elements[i].options[o][this.solutions[id]]);
                $("#p" + id).addClass("dianasSelect_correcta");
                    
                id++;
            }
        }
        
    },
    /**
     * Parsea el JSON de la actividad y lo guarda en el objeto JS de la misma
     * 
     * @param activity El JSON obtenido para la actividad
     */
    parseActivityJson: function(activity) {
        // Descodificamos el contenido de la actividad
        // y lo guardamos en el objeto de la actividad
        for (var i = 0; i < activity.soluciones.length; i++) {
            this.solutions[i] = base64.decode(activity.soluciones[0]);
        }
        for (var i = 0; i < activity.elementos.length; i++) {
            this.elements[i] = {
                text: base64.decode(activity.elementos[i][0]).split('<>'),
                options: []
            };

            for (var o = 1; o < activity.elementos[i].length; o++) {
                // Inicializamos el array
                this.elements[i].options[o - 1] = [];

                // Y añadimos las opciones
                for(var u = 0; u < activity.elementos[i][o].length; u++) {
                    this.elements[i].options[o - 1][u] = base64.decode(activity.elementos[i][o][u]);
                }
            }
        }

        // Obtenemos los datos básicos de la actividad
        this.title = activity.titulo;
        this.statement = activity.enunciado;
        this.icon = activity.icono;
        this.code = activity.codigo;
        // TODO: El problema de hacer esto así es que si hay más contenido en la página
        // el tiempo que el usuario está viendo el resto del contenido también cuenta
        this.startDate = new Date();

        // Escribimos la actividad en pantalla
        this.draw();

        // Mostramos la actividad
        $('.activity-content').show();
        // Y redimensionamos la pantalla
        $(window).trigger('resize');
    },
    /**
     * Escribe la actividad al HTML de la página
     */
    draw: function() {
        // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
        $("#titular").text(this.title);
        $("#enunciado").text(this.statement);
        
        // Añadimos el bloque de respuestas vacío
        $("#salida").html('<ol id="cuestionario"></ol>');

        // Añadimos una clase específica
        $("#salida").addClass('select-word-activity');

        var id = 0;
        for (var i = 0; i < this.elements.length; i++) {
            var line = '';

            for(var o = 0; o < this.elements[i].text.length - 1; o++) {
                var options = '';

                for(var u = 0; u < this.elements[i].options[o].length; u++) {
                    options += '<option value="' + this.elements[i].options[o][u] + '">' + this.elements[i].options[o][u] + '</option>';
                }

                line += this.elements[i].text[o] +
                    '<div id="rp' + id + '" class="preDianaSelect"></div>' +
                    '<select class="fillDianasSelect" id="p' + id + '">' +
                        '<option value=""></option>' +
                        options +
                    '</select>';
                
                id++;
            }

            line += this.elements[i].text[this.elements[i].text.length - 1];

            // Componemos el elemento de la línea
            $("#cuestionario").append(
                '<li id="q' + (i + 1) + '" class="question">' +
                    '<span  class="numero">' + (i + 1) + '. </span>' +
                    line +
                '</li>'
            );
        }

        // Ocultamos el botón de reiniciar y mostramos el de corregir
        $(".reiniciar").hide();
        $(".submit").show();
    }
}
