/**
 * Actividad "Ordenar"
 */
var sort = {
    // Variables internas de la actividad
    solutions: [],
    sentences: [],
    letters: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.solutions = [];
        this.sentences = [];
        this.letters = [];
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     * 
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // Lo hacemos por AJAX y no getJSON para poder usar la propiedad context
        // y así poder usar this dentro del callback
        $.ajax({
            dataType: "json",
            url: json_path,
            success: this.parseActivityJson,
            context: this
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            sort.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: this.solutions.length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        // Desactivamos la opción de ordenar
        $("#sort_palabras ul").sortable({
            disabled: true
        });

        for (i = 0; i < this.solutions.length; i++) {
             if( this.solutions[i] == $($("#sort_palabras ul li span").get(i)).text()) {
                $($("#sort_palabras ul li span").get(i)).prepend('<i class="fa fa-check feed_correcto"></i>');
                result.correct++;
             } else {
                 $($("#sort_palabras ul li span").get(i)).prepend('<i class="fa fa-times feed_incorrecto"></i>');
                 result.wrong++;
             }	
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        // Creamos un hash de soluciones (?)
        var hash = {};
        for (var i = 0; i < this.solutions.length; i++) {
            var key = $("#p" + i).text().slice(0,1);
            var value = $("#p" + i).text().slice(1);
            hash[key] = value; 
        }
        // Ahora comprobamos para cada opcion y pintamos en el orden correcto
        $("#sort_palabras ul").html('');
        for (var i = 0; i < this.solutions.length; i++) {
            $("#sort_palabras ul").append('<li id="p' + i + '" class="sort_elemPal"><span class="sort_opcion">' + sort.correccion[i]  +'</span>' + hash[sort.correccion[i]] + "</li>");
        }
    },
    /**
     * Parsea el JSON de la actividad y lo guarda en el objeto JS de la misma
     * 
     * @param activity El JSON obtenido para la actividad
     */
    parseActivityJson: function(activity) {
        if(activity.frases.length != activity.letras.length) {
            console.log("[ERROR] sort.js | El fichero JSON de la actividad no tiene el mismo número de letrasy frases.");
            return;
        }

        // Descodificamos el contenido de la actividad
        // y lo guardamos en el objeto de la actividad
        for(var i = 0; i < activity.frases.length; i++) {
            this.sentences[i] = base64.decode(activity.frases[i]);
            this.letters[i] = base64.decode(activity.letras[i]);
        }

        // Obtenemos los datos básicos de la actividad
        this.title = activity.titulo;
        this.statement = activity.enunciado;
        this.icon = activity.icono;
        this.code = activity.codigo;
        // TODO: El problema de hacer esto así es que si hay más contenido en la página
        // el tiempo que el usuario está viendo el resto del contenido también cuenta
        this.startDate = new Date();

        // Escribimos la actividad en pantalla
        this.draw();

        $("#sort_palabras ul").sortable();

        // Mostramos la actividad
        $('.activity-content').show();
        // Y redimensionamos la pantalla
        $(window).trigger('resize');
    }, 
    /**
     * Escribe la actividad al HTML de la página
     */
    draw: function() {
        // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
        $("#titular").text(this.title);
        $("#enunciado").text(this.statement);

        // Añadimos el bloque de respuestas vacío
        $("#salida").html(
            '<div class="grafico"></div>' +
            '<div id="sort_palabras">' +
                '<ul class="lista bloquePal_sort"></ul>' +
            '</div>'
        );

        
        // Guardamos la solución
        // TODO: Porqué slice?? (Quizás para clonar??)
        this.solutions = this.letters.slice(0);
        
        // Ordenamos las respuestas según la letra
        this.letters.sort();
        
        for (var i = 0; i < this.sentences.length; i++) {
            $("#sort_palabras ul").append(
                '<li id="p' + i + '" class="sort_elemPal">' +
                    '<span class="sort_opcion">' + this.letters[i] + '</span>' +
                    this.sentences[i] +
                "</li>"
            );
        }

        // Ocultamos el botón de reiniciar y mostramos el de corregir
        $(".reiniciar").hide();
        $(".submit").show();
    }
}
