/**
 * Actividad "Test"
 */
var test = {
    // Variables internas de la actividad
    letters: [],
    solutions: [],
    elements: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.letters = [];
        this.solutions = [];
        this.elements = [];
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     *
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function(json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // TODO: esto debería llamar a una función de "test" para poder usar "this"
        $.getJSON(json_path, function(activity) {
            if (activity.soluciones.length != activity.elementos.length) {
                console.log("[ERROR] test.js | El fichero JSON de la actividad no tiene el mismo número de soluciones y elementos (" + json_path + ").");
                return;
            }

            // Descodificamos el contenido de la actividad
            // y lo guardamos en el objeto de la actividad
            for (var i = 0; i < activity.soluciones.length; i++) {
                test.solutions[i] = base64.decode(activity.soluciones[i]);
                test.elements[i] = {
                    questions: activity.elementos[i],
                    solution_index: i
                };
            }
            // Descodificamos las letras
            // TODO: Es realmente necesario guardar las letras así?
            for(var i = 0; i < activity.letras.length; i++) {
                test.letters[i] = base64.decode(activity.letras[i]);
            }

            // Obtenemos los datos básicos de la actividad
            test.title = activity.titulo;
            test.statement = activity.enunciado;
            test.icon = activity.icono;
            test.code = activity.codigo;
            // TODO: El problema de hacer esto así es que si hay más contenido en la página
            // el tiempo que el usuario está viendo el resto del contenido también cuenta
            test.startDate = new Date();

            // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
            $("#titular").text(test.title);
            $("#enunciado").text(test.statement);

            // Añadimos una clase específica a la actividad
            // TODO: Esto no se quita nunca, por lo que podría dar problemas si se
            // incluyen más de una actividad (comprobar que no se usa en el CSS y quitarlo de aquí)
            $("#salida").addClass("test");

            // Añadimos el listado de preguntas vacío
            $("#salida").html('<ol id="cuestionario"></ol>');

            // Desordenamos las preguntas
            // TODO: Debería ser opcional que se reordenen
            // TODO: También se debería poder reordenar las respuestas
            test.elements = $(test.elements).shuffleArray();

            // Metemos las preguntas
            for (i = 0; i < test.elements.length; i++) {
                var subElements = '';
                for(var o = 1;o < test.elements[i].questions.length; o++) {
                    subElements += '<li class="a' + o + '">';
                        subElements += '<label>';
                            subElements += '<input type="radio" name="q' + (test.elements[i].solution_index + 1) + '" />';
                            subElements += '<span class="numero">' + test.letters[o - 1] + ')</span> ';
                            subElements += '<p class="text_2lineasTest">' + base64.decode(test.elements[i].questions[o]) + '</p>';
                        subElements += '</label>';
                    subElements += '</li>';
                }

                $('#cuestionario').append(
                    '<li id="' + (i + 1) + '" class="question">' +
                        '<span class="numero">' + (i + 1) + '. </span>' +
                        '<span class="tit_preg">' + base64.decode(test.elements[i].questions[0]) + '</span>' +
                        '<ol>' + subElements + '</ol>' +
                    '</li>'
                );


            }

            // Ocultamos el botón de reiniciar y mostramos el de corregir
            $(".reiniciar").hide();
            $(".submit").show();

            // Hacemos que se incluya la clase selected en el li al seleccionar una opción
            $("input[type='radio']").on('change', function(e) {
                if($(this).is(':checked')) {
                    $(this).parents('li').not('.question').addClass('selected');
                    $(this).parents('li').not('.question').siblings().removeClass('selected');
                }
            });

            // Mostramos la actividad
            $('.activity-content').show();
            // Y redimensionamos la pantalla
            $(window).trigger('resize');
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            test.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: test.solutions.length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        for(var i = 0; i < test.solutions.length; i++) {
            // Cogemos el ID de la pregunta actual
            var input = $('[name="q' + (i + 1) + '"]:checked');

            // Deshabilitamos el radio button
            input.attr('disabled', true);

            // Obtenemos el elemento li
            var li_element = input.closest('li');

            // Si es la respuesta seleccionada es correcto
            if(li_element.is('.selected.a' + test.solutions[i])) {
                li_element.append('<i class="fa fa-check visible feed_correcto"></i>').addClass("a_acierto");
                li_element.append('<div class="flotante">' + random_acierto() + '</div>');
                result.correct++;
            // En caso contrario es incorrecto
            } else {
                li_element.append('<i class="fa fa-times visible feed_incorrecto"></i>').addClass("a_fallo");
                // Descomentar esto si se quiere un mensaje de fallo
                // li_element.append('<div class="flotante">' + random_fallo() + '</div>');
                result.wrong++;
            }
        }

        // Calculamos la puntuación (parseInt para obtener solo la parte entera)
        result.score = parseInt(10 * result.correct / test.solutions.length);
        // Componemos el feedback
        result.feedback = 'Has acertado ' + result.correct + ' preguntas. Tiempo de realización: ' + result.time + 'segundos.';

        // Desactivamos la posibilidad de seleccionar una respuesta
        $("input[type='radio']").off('change');

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        // TODO: Rehacer esta función correctamente
        /*var total = 0;
        jQuery.each(test.soluciones, function () {
            total++;
            var id = $("#q" + total).attr("id");

             $("#" + id + " .a" + this).append("<img src='img/circle.png'  alt=''>");

            // Pasamos el texto al div que tenemos que utilizar para el hack
            respuesta.parent().parent().html(respuesta.parent().parent().html() + respuesta.text());
        });*/
    }
}
