/**
 * Actividad "Texto con test"
 */
var test_and_text = {
    // Variables internas de la actividad
    letters: [],
    solutions: [],
    elements: [],
    title: "",
    statement: "",
    icon: "",
    code: "",
    text: "",
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.letters = [];
        this.solutions = [];
        this.elements = [];
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.text = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     * 
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function (json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // Lo hacemos por AJAX y no getJSON para poder usar la propiedad context
        // y así poder usar this dentro del callback
        $.ajax({
            dataType: "json",
            url: json_path,
            success: this.parseActivityJson,
            context: this
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            test_and_text.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
        this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: this.solutions.length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

        // Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();
       
        for(var i = 0; i < this.solutions.length; i++) {
            // Cogemos el id del elemento a corregir
            var id = "q" + (i + 1);

            // Nos acercamos a la clase de item de la lista chequeado para comparar (??)
            var css_class = $("#" + id + " input:checked").closest("li").attr("class");

            // Deshabilitamos el radio
            $("#" + id + " input:radio").attr('disabled', true);

            if ("a" + this.solutions[i] + " selected" == css_class) {
                $("#" + id + " input:checked").closest("li").append('<i class="fa fa-check visible feed_correcto"></i>');
                $("#" + id + " input:checked").closest("li").addClass("a_acierto");
                $("#" + id + " input:checked").closest("li").append('<div class="flotante">' + random_acierto() + '</div>');
                result.correct++;
            } else {
                $("#" + id + " input:checked").closest("li").append('<i class="fa fa-times visible feed_incorrecto"></i>');
                $("#" + id + " input:checked").closest("li").addClass("a_fallo");
                // Descomentar esto si se quiere un mensaje de fallo
                // $("#" + id + " input:checked").closest("li").append('<div class="flotante">' + random_fallo() + '</div>');
                result.wrong++;
            }    
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');
    
        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();
        
        // TODO: Rehacer esta función correctamente
        /*jQuery.each(test_and_text.soluciones, function () {
            var id = $("#q" + total).attr("id");    
            
            // HACK para dar "estilo" al borde de los botones radio
            //le añadimos el círculo corrector
            var respuesta = $("#" + id + " .a" + this + " input[type=radio]");

            // Añadimos el borde a la respuesta. Se tratan de 2 divs: el padre de todos va a contener el segundo div que generamos y el 
            // texto de la respuesta, y el segundo div, va a contener estilos para dibujar el contorno verde alrededor del radio button
            //respuesta.wrap("<div style='display: inline;'><div style='display: inline; border:1px solid rgb(0, 173, 38);" +
            //	" text-align:center; background-color: green; border-radius: 50%;'></div></div>");
            
             $("#" + id + " .a" + this).append("<img src='img/circle.png'  alt=''>"); 
                    
            // Pasamos el texto al div que tenemos que utilizar para el hack
            respuesta.parent().parent().html(respuesta.parent().parent().html() + respuesta.text());
            
            // Reestablecemos el check
            //if(respuesta.attr("checked")) {
                // La referencia a la respuesta que teníamos anteriormente ha sido borrada, por lo que necesitamos una nueva
            //	$("#" + id + " .a" + this + " input[type=radio]").attr("checked", true);
            //}
        });*/
    },
    /**
     * Parsea el JSON de la actividad y lo guarda en el objeto JS de la misma
     * 
     * @param activity El JSON obtenido para la actividad
     */
    parseActivityJson: function(activity) {
        // Descodificamos el contenido de la actividad
        // y lo guardamos en el objeto de la actividad
        for(var i = 0; i < activity.letras.length; i++) {
            this.letters[i] = base64.decode(activity.letras[i]);
        }
        for(var i = 0; i < activity.soluciones.length; i++) {
            this.solutions[i] = base64.decode(activity.soluciones[i]);
        }
        for(var i = 0; i < activity.elementos.length; i++) {
            this.elements[i] = activity.elementos[i];
        }

        // Obtenemos los datos básicos de la actividad
        this.title = activity.titulo;
        this.statement = activity.enunciado;
        this.icon = activity.icono;
        this.code = activity.codigo;
        this.text = base64.decode(activity.texto);
        // TODO: El problema de hacer esto así es que si hay más contenido en la página
        // el tiempo que el usuario está viendo el resto del contenido también cuenta
        this.startDate = new Date();

        // Escribimos la actividad en pantalla
        this.draw();

        // Nunca debería estar puesto este evento, ya que hasta
        // ahora no existían los checkboxes, pero por si acaso
        $(".test-and-text-radio").off('change');
        $(".test-and-text-radio").on('change', function(e) {
            if($(this).is(':checked')) {
                $(this).parents('li').not('.question').addClass('selected');
                $(this).parents('li').not('.question').siblings().removeClass('selected');
            }
        });

        // Mostramos la actividad
        $('.activity-content').show();
        // Y redimensionamos la pantalla
        $(window).trigger('resize');
    },
    /**
     * Escribe la actividad al HTML de la página
     */
    draw: function() {
        // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
        $("#titular").text(this.title);
        $("#enunciado").text(this.statement);

        // Añadimos una clase específica
        // TODO: Esta clase nunca se quita, por lo que podría dar problemas si hay varias actividades
        $("#salida").addClass("test_and_text");

        // Añadimos el bloque de respuestas vacío
        $("#salida").html(
            '<div id="text" class="textos">' + this.text + '</div>' +
            '<ol id="cuestionario"></ol>'
        );

        // Desordenamos las preguntas
        // TODO: Debería ser opcional que se reordenen
        // TODO: También se debería poder reordenar las respuestas
        this.elements = $(this.elements).shuffleArray();

        // Metemos las preguntas
        for (i = 0; i < this.elements.length; i++) {
            var sub_elements = '';
            for(o = 1; o < this.elements[i].length; o++) {
                sub_elements += '<li class="a' + o + '">' +
                    '<label>' +
                        '<input type="radio" name="q' + (i + 1) + '" class="test-and-text-radio" />' +
                        '<span class="numero">' + this.letters[o - 1] + ')</span> ' +
                        '<p class="texto_2lineastest_and_text">' + base64.decode(this.elements[i][o]) + '</p>' +
                    '</label>' +
                '</li>';
            }

            $('#cuestionario').append(
                '<li id="q' + (i + 1) + '" class="question">' +
                    '<span class="numero">' + (i + 1) + '. </span>' +
                    '<span class="tit_preg">' + base64.decode(this.elements[i][0]) + '</span>' +
                    '<ol>' + sub_elements + '</ol>' +
                '</li>'
            );
        }

        // Ocultamos el botón de reiniciar y mostramos el de corregir
        $(".reiniciar").hide();
        $(".submit").show();
    }
}
