/**
 * Actividad "Escribir palabra"
 */
var escribir_parte = {
    // Variables internas de la actividad
    elements: [],
    title: '',
    statement: '',
    icon: '',
    code: '',
    startDate: null,
    /**
     * Función para inicializar las variables internas de esta actividad
     */
    reset: function() {
        this.elements = [];
        this.title = '';
        this.statement = '';
        this.icon = '';
        this.code = '';
        this.startDate = null;
    },
    /**
     * Función para inicializar la actividad
     *
     * @param json_path Ruta al fichero JSON que contiene la información de la actividad
     */
    init: function (json_path) {
        // Inicializamos las variables internas
        this.reset();

        // Obtenemos el fichero JSON con la información de la actividad
        // Lo hacemos por AJAX y no getJSON para poder usar la propiedad context
        // y así poder usar this dentro del callback
        $.ajax({
            dataType: "json",
            url: json_path,
            success: this.parseActivityJson,
            context: this
        });

        // Añadimos el evento para reiniciar la actividad
        $(".reiniciar").off('click');
        $(".reiniciar").on('click', { json_path: json_path }, function(e) {
            escribir_parte.init(e.data.json_path);
        });
    },
    /**
     * Función para comprobar los resultados del usuario
     */
    check: function() {
        // Obtenemos la fecha de finalización
		this.endDate = new Date();
        var result = {
            correct: 0,
            wrong: 0,
            total: this.elements.length,
            time: (this.endDate - this.startDate) / 1000,
            score: 0,
            feedback: ''
        };

		// Mostramos el botón de reiniciar y ocultamos el de comprobar
        $(".reiniciar").show();
        $(".submit").hide();

        var id = 0;
        for (var i = 0; i < this.elements.length; i++) {
            // Deshabilitamos la caja de texto
            $("#rp" + i).attr('disabled', true);
            // Comprobamos si la respuesta es correcta
            if ($("#rp" + i).val().toLowerCase() == this.elements[i].answer.toLowerCase()) {
                // Esta linea marca de verde las correctas
                $("#rp" + i).addClass("dianasSelect_correcta");
                $("#correcion" + i).prepend('<i class="fa fa-check feed_correcto"></i>');
                result.correct++;
            } else {
                // Esta linea marca de rojo las incorrectas
                $("#rp" + i).addClass("dianasSelect_incorrecta");
                $("#correcion" + i).prepend('<i class="fa fa-times feed_incorrecto"></i>');
                result.wrong++;
            }
        }

        // Redimensionamos la pantalla por si ha cambiado el tamaño de la actividad
        $(window).trigger('resize');

        return result;
    },
    /**
     * Función para mostrar la solución de la actividad
     */
    solve: function() {
        // Mostramos el botón de reiniciar y ocultamos los de Ver solución y Comprobar
        $(".reiniciar").show();
        $(".submit").hide();
        $(".solucion").hide();

        for(var i = 0; i < this.elements.length; i++) {
            $("#rp" + i).val(this.elements[i].answer.toLowerCase());
            $("#rp" + i).addClass("dianasSelect_correcta");
        }
    },
    /**
     * Parsea el JSON de la actividad y lo guarda en el objeto JS de la misma
     *
     * @param activity El JSON obtenido para la actividad
     */
    parseActivityJson: function(activity) {
        // Descodificamos el contenido de la actividad
        // y lo guardamos en el objeto de la actividad
        for(var i = 0; i < activity.elementos.length; i++) {
            this.elements[i] = {
                text: base64.decode(activity.elementos[i].elemento),
                answer: base64.decode(activity.elementos[i].correcta)
            };
        }

        // Obtenemos los datos básicos de la actividad
        this.title = activity.titulo;
        this.statement = activity.enunciado;
        this.icon = activity.icono;
        this.code = activity.codigo;
        // TODO: El problema de hacer esto así es que si hay más contenido en la página
        // el tiempo que el usuario está viendo el resto del contenido también cuenta
        this.startDate = new Date();

        // Escribimos la actividad en pantalla
        this.draw();

        // Mostramos la actividad
        $('.activity-content').show();
        // Y redimensionamos la pantalla
        $(window).trigger('resize');
    },
    draw: function() {
        // Revisar: ¿Esto debería ser con HTML o con text? (text es más "seguro")
        $("#titular").text(this.title);
        $("#enunciado").text(this.statement);

        // Añadimos el bloque de respuestas vacío
        $("#salida").html('<div id="cuestionario"></div>');

        // Añadimos una clase específica
        $("#salida").addClass('write-word-activity');

        // Metemos las frases
        for(var i = 0; i < this.elements.length; i++) {
            $('#cuestionario').append(
                '<li id="q' + i + '" class="question">' +
                    '<div class="imput_text">' +
                        '<div class="text_right">' +
                            '<span class="numero">' + (i + 1) + '. </span>' +
                            this.elements[i].text +
                        '</div>' +
                        '<div id="correcion' + i + '" class="preDianaSelect"></div>' +
                        '<input type="text" class="fillDianasSelect" id="rp' + i + '" />' +
                    '</div>' +
                '</li>'
            );
        }

        // Ocultamos el botón de reiniciar y mostramos el de corregir
		$(".reiniciar").hide();
		$(".submit").show();
    }
}
