//@version v.00.00.03
/**
 * init.js
 * Funciones de inicio de la píldora formativa.
 */

// Chamilo routing
var url = new URL(window.location.href);
var params = new URLSearchParams(url.search);
var pageValue = params.get('page');
if (pageValue) {
  // Recargamos la página indicando mediante un hash el número de página indicado como parámetro
  var urlWithoutParams = location.protocol + '//' + location.host + location.pathname;
  window.location.href = urlWithoutParams + '#page/' + pageValue;
}

// Nombre del fichero XML donde se guarda el índice de la píldora
var INDEX_XML_FILENAME = "ehabilis_content.xml";
// Iniciar el engine TinCanAPI
var eHabilisActivity = {};
// Información sobre el contenido de la píldora
var contentInfo = {
  // ID único de la píldoras
  id: "",
  // Tipo de actividad TinCan
  type: "",
  // Nombre de la píldora
  name: "",
  // Descripción de la píldora
  description: "",
  // Fichero de inicio de la píldora
  launch: "",
  // Contenido del índice
  units: [],
  //Indica si la píldora tiene varias páginas o no
  has_pagination: "",
  // * Indica si la píldora debe mostrar la numeración en el menú desplegable
  has_menu_numeration: "",
};
// TinCanAPI
var tincan = undefined;
var scormAPI = undefined;
var scormAPI2004 = undefined;

// Indica si se ha finalizado la sesión de conexión del Scorm
var finishSession = false;

var lastPage = 0;

var attemptedQuizScorm = [];

$(function () {
  // Deshabilitar el click derecho
  // ATENCIÓN: Es posible que de problemas en IE8 (http://www.quirksmode.org/dom/events/contextmenu.html)
  document.addEventListener(
    "contextmenu",
    function (e) {
      e.preventDefault();
    },
    false
  );

  // Asociamos el callback para controlar la redimensión de la ventana
  // TODO: Comprobar lo del padre
  $(window).on("resize", handleResize);
  try {
    $(window.parent).on("resize", handleResize);
  } catch (error) {
    console.error("App catch cross origin error", error);
  }

  // Registrar el handler que se invocará cuando todas las llamadas ajax han terminado
  // (cuando se ha recuperado el contenido de la píldora)
  // para enviar el tamaño del body a la página padre
  // TODO: Esto no se ejecuta cuando se envían datos de uso al portal??
  $(document).ajaxStop(function () {
    // Enviamos el alto y hacemos scroll
    $(window).trigger("resize", [true]);

    // Cuando se acaben de cargar las imágenes enviamos el alto también
    $("img").on("load", function () {
      $(window).trigger("resize", [false]);
    });

    // Buscar imágenes grandes y añadir el botón de ampliar
    processZoomImages();
  });

  // Cuando se cambian las pestañas se debe actualizar el alto
  $(document).on("shown.bs.tab", ".nav-tabs li", function () {
    $(window).trigger("resize", [false]);
  });

  // Nota: ¿Se debería comprobar que se esté en un IFrame antes de asociar los callback?
  // No creo que ahorremos mucho pero...

  // Asociamos un callback al evento show de la ventana modal de Bootstrap para corregir su posición dentro del IFrame
  $(document).on("show.bs.modal", ".modal", fixModalPosition);
  // Y otro al evento shown por si al mostrarlo queda fuera del IFrame
  $(document).on(
    "shown.bs.modal",
    ".modal",
    { visible: true },
    fixModalPosition
  );

  //galeria_imagenes(); -- Galería de imágenes TODO: Implementar en el portal (A no ser que haya que meterlo dentro de la píldora)
  //recursos_ext(); -- Rescursos externos (Enlaces?)

  TinCan.enableDebug();

  var tipo_scorm = esScorm();
  var file_xml = "tincan.xml";
  var tipo_info = "TinCan";

  if (tipo_scorm) {
    file_xml = "imsmanifest.xml";
    tipo_info = "SCORM";
  }

  console.log("Cargar información de " + tipo_info + " desde " + file_xml);
  $.ajax({
    type: "GET",
    url: file_xml,
    dataType: "xml",
    success: function (info) {
      console.log("Información cargada correctamente");
      initTinCanAPI(info);

      // Iniciar las rutas de la píldora
      // Lo hacemos aquí para evitar que se intenten enviar datos al LRS antes de inicializar el TinCan
      routingInit();
    },
    error: function () {
      console.log(
        "Se ha producido un error al obtener la información de " +
          tipo_info +
          "."
      );
    },
  });

  // Actualizar el tamaño cuando se carga un iframe
  $(window).on("load", "iframe", function () {
    $(window).trigger("resize", [true]);
  });
});

// Enviar tamaño del body a la pagina padre (cuando la píldora está en iframe) al cargar la página
$(window).on("load", function () {
  $(window).trigger("resize", [true]);
});

checkAccessMenuLink();
createKeyboardShortcut();

/**
 * Comprueba si es scorm a través de métodos del padre.
 *
 * En la app este método provoca un error de cross origin. De momento devolvemos
 * false ya que no se van a tratar las píldoras scorm. Cuando se traten desde la
 * app, se deberá implementar otra forma de realizar esta comprobación.
 *
 * @author david.puente@sdweb.es
 * @date 2021-04-19
 * @returns Boolean
 */
function esScorm() {
  try {
    return (
      (window.opener && (window.opener.API || window.opener.API_1484_11)) ||
      (window.parent && (window.parent.API || window.parent.API_1484_11))
    );
  } catch (error) {
    console.error("App catch cross origin error", error);
    return false;
  }
}

/**
 * Inicialización de la API de TinCan.
 */
function initTinCanAPI(info) {
  // Obtenemos la primera actividad
  let activity = $(info).find("tincan").find("activities").find("activity")[0];

  // Obtenemos el ID y el tipo de la píldora
  contentInfo.id = $(activity).attr("id");
  contentInfo.type = $(activity).attr("type");

  // Obtenemos nombre, descripción y fichero de inicio
  contentInfo.name = $(activity).find("name").text();
  contentInfo.description = $(activity).find("description").text();
  contentInfo.launch = $(activity).find("launch").text();

  // Obtenemos el IRI de la píldora
  // TODO: Esto también se podría meter en ehabilis_content.xml
  var contentIri = window.location.href;

  // En caso de que se abra la píldora en una nueva ventana
  if (GetURLParameter("activity_id")) {
    contentIri = decodeURIComponent(GetURLParameter("activity_id"));
  }

  try {
    if (window.top != null && typeof window.top.getMainIdIRI != "undefined") {
      // En caso de que se abra la píldora en un iframe
      contentIri = window.top.getMainIdIRI() + contentInfo.id;
    } else {
      // En caso de que se abra la píldora en una ventana
      if(contentIri.indexOf('portal/ehabilis/iri') == -1){
        // Solo concatena la url en caso de que no se reciba
        contentIri = window.location.origin + "/portal/ehabilis/iri/" + contentIri;
      }
    }
    // Obtenemos el Nid de la píldora
    if (window.top != null && typeof window.top.getMainNid != "undefined") {
      contentIri = contentIri + "_" + window.top.getMainNid();
    }
  } catch (error) {
    if(contentIri.indexOf('portal/ehabilis/iri') == -1){
        // Solo concatena la url en caso de que no se reciba
        contentIri = window.location.origin + "/portal/ehabilis/iri/" + contentIri;
    }
    console.error("App catch cross origin error", error);
  }

  // Inicializar los datos de la píldora para la API de TinCan
  eHabilisActivity.CourseActivity = {
    id: contentIri,
    definition: {
      type: contentInfo.type,
      name: {
        "es-ES": contentInfo.name,
      },
      description: {
        "es-ES": contentInfo.description,
      },
    },
  };

  eHabilisActivity.getContext = function (parentActivityId, isAssessment) {
    isAssessment = typeof isAssessment !== "undefined" ? isAssessment : false;

    // TODO: Qué es esto?
    var ctx = {
      contextActivities: {
        grouping: [
          {
            id: eHabilisActivity.CourseActivity.id,
          },
        ],
      },
    };

    if (parentActivityId !== undefined && parentActivityId !== null) {
      ctx.contextActivities.parent = {
        id: parentActivityId,
      };
    }
    if (isAssessment) {
      ctx.contextActivities.grouping.push({
        id: eHabilisActivity.CourseActivity.id + "/ActivityAssessment",
      });
    }

    return ctx;
  };

  // Si en la URL existe un parámetro endpoint inicializamos el motor TinCan
  if (
    window.location.href.indexOf("?endpoint=") != -1 ||
    window.location.href.indexOf("&endpoint=") != -1
  ) {
    // Inicializar la propia API de TinCan
    tincan = new TinCan({
      url: window.location.href,
      activity: {
        id: eHabilisActivity.CourseActivity.id,
        definition: {
          name: {
            "es-ES": contentInfo.name,
          },
          description: {
            "es-ES": contentInfo.description,
          },
          type: contentInfo.type,
        },
      },
    });
  } else {
    // En caso de que no exista endpoint, comprobamos si existe una API SCORM,
    // para esto, tenemos que comprobar si existe el objeto API en la ventana padre o
    // en la ventana opener
    try {
      if (window.opener && window.opener.API) {
        scormAPI = window.opener.API;

        scormAPI.LMSInitialize("");
      } else if (window.opener && window.opener.API_1484_11) {
        scormAPI2004 = window.opener.API_1484_11;

        scormAPI2004.Initialize("");
      } else if (window.parent && window.parent.API) {
        scormAPI = window.parent.API;

        scormAPI.LMSInitialize("");
      } else if (window.parent && window.parent.API_1484_11) {
        scormAPI2004 = window.parent.API_1484_11;

        scormAPI2004.Initialize("");
      }
    } catch (error) {
      console.error("App catch cross origin error", error);
    }
  }
}

/**
 *  Obtiene los parámetros de una URL
 */
function GetURLParameter(sParam) {
  var sPageURL = window.location.search.substring(1);
  var sURLVariables = sPageURL.split("&");
  for (var i = 0; i < sURLVariables.length; i++) {
    var sParameterName = sURLVariables[i].split("=");
    if (sParameterName[0] == sParam) {
      return sParameterName[1];
    }
  }

  return false;
}

/**
 *  Comprueba si se puede acceder a los botones y elementos del menú
 */
function checkAccessMenuLink(){
  // Comprueba si existen condiciones de avance
  let isMeetProgressInput = document.querySelectorAll('.meet-progress-condition-class');
  // Si no hay contenido con condiciones se desbloquean los botones
  if(isMeetProgressInput.length == 0){
    unlockNextButtons();
  }

  // Devuelve todos los enlaces del menú, si existen
  let menuLink = document.querySelectorAll('.node-title-link');
  if(menuLink){
      let i;
      for(i = 0; i < menuLink.length; i++){
          menuLink[i].addEventListener('click', function(e){
            // Si el enlace del menú tiene la clase, no se permite hacer click
            if(this.classList.contains('deactivate-menu-link')){
              e.preventDefault();
            }
          }, false);
      }
  }

  // Comprueba si se puede navegar a la siguiente página al pinchar en los enlaces de siguiente
  navigateNextPagePill();
}

function createKeyboardShortcut() {

  let teclasPresionadas = {};

  const teclasHome = $ehabilis_custom_texts.custom_input_home;
  const teclasPreview = $ehabilis_custom_texts.custom_input_preview;
  const teclasNext = $ehabilis_custom_texts.custom_input_next;
  const teclasMenu = $ehabilis_custom_texts.custom_input_menu;

  if(teclasHome.length > 0) {
    var teclasHomeArray = teclasHome.split('+');
    var teclaHome1 = teclasHomeArray[0].trim();
    var teclaHome2 = teclasHomeArray[1].trim();

    var teclasInicioAsignadas = {
      'tecla1': teclaHome1,
      'tecla2': teclaHome2,
      'tipo': 'inicio'
    };
  }

  if(teclasPreview.length > 0) {
    var teclasPreviewArray = teclasPreview.split('+');
    var teclaPreview1 = teclasPreviewArray[0].trim();
    var teclaPreview2 = teclasPreviewArray[1].trim();

    var teclasAnteriorAsignadas = {
      'tecla1': teclaPreview1,
      'tecla2': teclaPreview2,
      'tipo': 'anterior'
    };
  }

  if(teclasNext.length > 0) {
    var teclasNextArray = teclasNext.split('+');
    var teclaNext1 = teclasNextArray[0].trim();
    var teclaNext2 = teclasNextArray[1].trim();

    var teclasSiguienteAsignadas = {
      'tecla1': teclaNext1,
      'tecla2': teclaNext2,
      'tipo': 'siguiente'
    };
  }

  if(teclasMenu.length > 0) {
    var teclasMenuArray = teclasMenu.split('+');
    var teclaMenu1 = teclasMenuArray[0].trim();
    var teclaMenu2 = teclasMenuArray[1].trim();

    var teclasMenuAsignadas = {
      'tecla1': teclaMenu1,
      'tecla2': teclaMenu2,
      'tipo': 'menu'
    };
  }

  // Agregar el evento keydown
  document.addEventListener('keydown', (evento) => {

    // * Evento para ir a inicio
    if(typeof teclasInicioAsignadas !== 'undefined') {
      teclasPresionadas = teclasPresionadasEvento(teclasPresionadas, evento, teclasInicioAsignadas);
    }
    if(typeof teclasSiguienteAsignadas !== 'undefined') {
      // * Evento para ir a la siguiente página
      teclasPresionadas = teclasPresionadasEvento(teclasPresionadas, evento, teclasSiguienteAsignadas);
    }
    if(typeof teclasAnteriorAsignadas !== 'undefined') {
      // * Evento para ir a la anterior página
      teclasPresionadas = teclasPresionadasEvento(teclasPresionadas, evento, teclasAnteriorAsignadas);
    }
    if(typeof teclasMenuAsignadas !== 'undefined') {
      // * Evento para ir a la anterior página
      teclasPresionadas = teclasPresionadasEvento(teclasPresionadas, evento, teclasMenuAsignadas);
    }
  });

  document.addEventListener('keyup', (evento) => {
    teclasPresionadas[evento.key.toUpperCase()] = false;
  });
}

/**
 *
 * @param {*} tecla1
 * @param {*} tecla2
 * @param {*} tipo
 */
function teclasPresionadasEvento(teclasPresionadas, evento, teclasAsignadas) {

  console.log(evento.key.toUpperCase())
  teclasPresionadas[evento.key.toUpperCase()] = true;  // Marcar la tecla como presionada

  if (teclasPresionadas[teclasAsignadas.tecla1] && teclasPresionadas[teclasAsignadas.tecla2]) {
    // window.location.href = window.location.origin + window.location.pathname + '#page/1'
    // location.reload();
    switch(teclasAsignadas.tipo) {
      case 'inicio':
        teclaInicioEvento();
        break;
      case 'siguiente':
        teclaSiguienteEvento();
        break;
      case 'anterior':
        teclaAnteriorEvento();
        break;
      case 'menu':
        teclaMenuEvento();
        break;
    }
  }

  return teclasPresionadas;

}

function teclaInicioEvento() {
  var esFinalScorm = finishScormCheck();
  if (!esFinalScorm) {
    var inicioButton = $(".home-link")[0];
    inicioButton.click();
  }
}

function teclaAnteriorEvento() {
  var esFinalScorm = finishScormCheck();
  if (esFinalScorm) {
    if($(".previous-button-link-finish:visible").length > 0) {
      var anteriorButton = $(".previous-button-link-finish:visible")[0];
      anteriorButton.click();
    }
  } else {
    var anteriorButton = $(".previous-button-link")[0];
    anteriorButton.click();
  }
}

function teclaSiguienteEvento() {
  var esFinalScorm = finishScormCheck();
  if (esFinalScorm) {
    if($(".next-button-link-finish:visible").length > 0) {
      var siguienteButton = $(".next-button-link-finish:visible")[0];
      siguienteButton.click();
    }
  } else {
    var siguienteButton = $(".next-button-link")[0];
    siguienteButton.click();
  }
}

function teclaMenuEvento() {
  var esFinalScorm = finishScormCheck();
  if(!esFinalScorm) {
    var menuButton =   $(".index-menu.menu-button")[0];
    menuButton.click();
  }
}

function finishScormCheck() {
  var elements = document.querySelectorAll(".scorm-finished-page");
  for (let element of elements) {
    var style = window.getComputedStyle(element);
    if (style.display != 'none') {
      return true;
    }
  }
  return false;
}

/**
 *  Comprueba si los botones (enlaces) tienen la clase que los bloquea y no permite avanzar
 *  Si no tienen la clase, activa el enlace del menú correspondiente
 */
function navigateNextPagePill(){
  // Se crea array con las clases de los distintos tipos de enlaces para avanzar en la píldora
  var classes = ['.next-button-link', '.next-button-menu-link', '.finish-button-link'];

  // Se crean los eventos para los distintos enlaces
  classes.forEach(function(elemClass){
    let element = document.querySelector(elemClass);
    if(element){
      // Al hacer click en un elemento se comprueba si tiene la clase que lo bloquea
      // si es asi, no permite continuar con el evento
      // en caso contrario, activa el enlace del menú
      element.addEventListener('click', function(e){
        if(this.classList.contains('deactivate-link')){
          e.preventDefault();
          e.stopImmediatePropagation();
        }
        else{
          unlockMenuLink(this.getAttribute('href'));
        }
      },false);
    }

  });

}

/**
 *  Activa el enlace del menú dependiendo del valor de "href"
 * @param {*} href
 */
function unlockMenuLink(href){

  // Se obtiene el enlace del menú que se corresponde con el href indicado
  element = document.querySelector('a[href="' + href + '"].node-title-link');
  if(element && element.classList.contains('deactivate-menu-link')){
    element.classList.remove('deactivate-menu-link');
  }

}

/**
 *  Recorre cada uno de los botones de avance (enlace de siguiente) y le elimina la clase que lo bloquea
 */
function unlockNextButtons(){

  var classes = ['.next-button-link', '.next-button-menu-link'];

  classes.forEach(function(elemClass){
      let element = document.querySelector(elemClass);
      // Si el elemento contiene la clase, se elimina dicha clase
      if(element
        && element.classList.contains('deactivate-link')){
          element.classList.remove('deactivate-link');
      }
  });
}


/**
 *
 *  * Cambia clase de botón "autores" para desplegar/plegar su contenido
 *
 */
function changeAuthorButtonClass() {
  var buttonClass = '.button-list-autores';

  let element = document.querySelector(buttonClass);
  if (
    element &&
    element.classList.contains('plegado')
  )
  {
    element.classList.remove('plegado');
    element.classList.add('desplegado');
  } else if (
    element &&
    element.classList.contains('desplegado')
  )
  {
    element.classList.remove('desplegado');
    element.classList.add('plegado');
  }
}