//@version v.00.00.03
/**
 * lib.js
 * Funciones genéricas del funcionamiento básico de la píldora
 */

// Actividad de la página actual (Creo?)
var actividad;

/**
 * Obtiene un array con los índices de los nodos
 */
function generateIndex(units) {
  let array_parents = Array(units.length).fill(false);
  let array_index = Array(units.length).fill("");
  let ni = [0];
  let n = 0;
  for (let i = 0; i < units.length; i++) {
    if (units[i].childs) {
      units[i].childs.forEach((e) => (array_parents[e] = i));
    }
  }
  for (let i = 0; i < units.length; i++) {
    let deep = 0;
    if (array_parents[i]) {
      let nparent = array_parents[i];
      while (nparent) {
        n == 0
          ? (array_index[i] = ni[n] - 1 + "." + array_index[i])
          : (array_index[i] += ni[n] - 1 + ".");
        nparent = array_parents[nparent];
        n++;
        deep++;
        ni.length > n ? ni[n]++ : ni.push(1);
      }
      array_index[i] += ni[n] + ".";
      for (let x = 1; x < deep; x++) {
        ni[x] -= 1;
      }
      for (let x = n + 1; x < ni.length; x++) {
        ni[x] = 0;
      }
      n = 0;
      deep = 0;
    } else {
      array_index[i] += ni[n] + ".";
      for (let x = 1; x < ni.length; x++) {
        ni[x] = 0;
      }
      ni[n]++;
      n = 0;
    }
  }
  return array_index;
}

/**
 * Inicialización del enrutado de la píldora
 */
function routingInit() {
  console.log(
    "Cargar el índice de la píldora desde el fichero ehabilis_content.xml"
  );

  $.ajax({
    type: "GET",
    url: INDEX_XML_FILENAME,
    dataType: "xml",
    success: function (index) {
      // Recorremos todas las unidades
      contentInfo.units = loadUnits($(index).find("content").children("unit"));

      var initPosQuizScorm = null;

      // Añadimos el texto del índice al nodo
      let array_index = generateIndex(contentInfo.units);
      for (let i = 0; i < contentInfo.units.length; i++) {
        contentInfo.units[i].indexstr = array_index[i];
        contentInfo.units[i].deep = array_index[i].split(".").length - 1;

        if(contentInfo.units[i].activities.length > 0 && initPosQuizScorm == null){
          // Se guarda la condición como atributo de la actividad
          if(contentInfo.units[i].activities.length > 1 && contentInfo.units[i].activities[2] != 'none'){
            initPosQuizScorm = i;
          }
        }
      }

      // Generamos lista menú índice
      let menu_index_ul = $(".menu-index-display ul.list-nodes");
      let previous_deep = 1;
      let previous_li = null;
      let previous_span_toggle = null;
      let array_sub_index = [];
      contentInfo.units.forEach(function (e) {
        // Elementos
        let li_element = $("<li></li>");
        let a_element = $("<a></a>");
        let span_toggle = $("<span></span>");
        let span_index = $("<span></span>");
        let span_name = $("<span></span>");
        // Añadimos clases
        li_element.addClass("node-" + e.index);
        li_element.addClass("deep-" + e.deep);
        if (e.index == 0) {
          li_element.addClass("home");
        }
        span_toggle.addClass("toggle");
        span_index.addClass("node-index");
        span_name.addClass("node-name");
        a_element.addClass("node-title-link");

        //if((e.index + 1) > 1){
        // Si el elemento actual es un cuestionario Scorm, se bloquean los elementos del menú a partir de él
        if(initPosQuizScorm != null && e.index > initPosQuizScorm){
          a_element.addClass("deactivate-menu-link");
        }
        li_element.addClass("expanded");
        // Valores de los elementos
        if (e.index != 0 && contentInfo.has_menu_numeration == 1) {
          span_index.html(e.indexstr);
        }
        span_name.append(e.name);

        contentInfo.has_menu_numeration = $(index)
        .find("content")
        .attr("has-menu-numeration");

        if (contentInfo.has_menu_numeration == 1) {
          a_element.append(span_index);
        }
        a_element.append(span_name);
        a_element.attr("href", "#page/" + (e.index + 1));
        li_element.append(span_toggle);
        li_element.append(a_element);
        // Sub índice
        if (e.deep > previous_deep) {
          let sub_index = $("<ul></ul>");
          sub_index.addClass("sub-index");
          sub_index.addClass("deep-" + e.deep);
          previous_li.addClass("parent");
          previous_li.append(sub_index);
          previous_li.removeClass("expanded");
          previous_li.addClass("collapsed");
          array_sub_index[e.deep] = sub_index;
        }
        // Añadimos elemento a ul
        if (e.deep == 1) {
          menu_index_ul.append(li_element);
        } else {
          array_sub_index[e.deep].append(li_element);
        }
        // Almacenamos valores actuales
        previous_span_toggle = span_toggle;
        previous_deep = e.deep;
        previous_li = li_element;
      });
      $("#node-header .list-nodes li .toggle").click(function (e) {
        let parent = $(e.target).parent();
        if (parent.hasClass("expanded") && parent.hasClass("parent")) {
          parent.addClass("collapsed");
          parent.removeClass("expanded");
        } else {
          parent.removeClass("collapsed");
          parent.addClass("expanded");
        }
      });

      // Botón de desplegar/contraer menú
      let menu_button = $(".index-menu");
      menu_button.click(function (e) {
        let menu_index = $(".menu-index-display");
        if (menu_index.hasClass("hidden-index")) {
          menu_index.removeClass("hidden-index");
          menu_index.addClass("visible-index");
          menu_button.addClass("selected");
          menu_index.animate({ width: "toggle" });
        } else {
          menu_index.addClass("hidden-index");
          menu_index.removeClass("visible-index");
          menu_button.removeClass("selected");
          menu_index.animate({ width: "toggle" });
        }
      });

      // Botón de contraer menú del propio menú
      let menu_button_exit = $("#node-header .menu-index-display-exit-button");
      menu_button_exit.click(function (e) {
        let menu_index = $(".menu-index-display");
        if (menu_index.hasClass("visible-index")) {
          menu_index.addClass("hidden-index");
          menu_index.removeClass("visible-index");
          menu_button.removeClass("selected");
          menu_index.animate({ width: "toggle" });
        }
      });

      console.log(contentInfo.units);

      console.log("Índice cargado correctamente:");
      console.log(contentInfo);

      // Se guarda el valor de has-pagination
      contentInfo.has_pagination = $(index)
        .find("content")
        .attr("has-pagination");
      // Si hay paginación, se muestra el bloque de los botones
      if (contentInfo.has_pagination == 1) {
        showNavigation();
      }

      // Inicializamos el estado
      // Obtiene el estado del curso y la última página
      var previouslyPage = 1;
      var bookmark = '';

      if(typeof scorm !== 'undefined'){
        bookmark = scorm.GetLessonLocation();

      }
      else if (scormAPI) {
        bookmark = scormAPI.LMSGetValue("cmi.core.lesson_location");

      }
      else if(scormAPI2004){

        bookmark = scormAPI2004.GetValue("cmi.location");
      }

      if(bookmark != ''){
        if (confirm('¿Deseas reanudar la sesión donde la dejaste anteriormente?')){
          previouslyPage = parseInt(bookmark, 10);
        }

      }

      // Inicializamos las rutas una vez que hemos cargado el índice
      console.log("Inicialización de las rutas.");

      // Definición de las rutas usando routie (http://projects.jga.me/routie/)
      routie({
        // Si se incluye la página en la ruta
        "page/:page": navigateToPage,
        // Si no se incluye nada, simplemente vamos a la primera página
        "": function () {
          navigateToPage(previouslyPage);
        },
      });

      console.log("Fin de inicialización de las rutas.");
    },
    error: function () {
      console.error("Se ha producido un error al obtener el índice.");
    },
  });
}

/**
 * Cargar el contenido de una página e incializar todos los componentes de la misma
 * TODO: Aquí se deberían cargar dinámicamente los JS/CSS necesarios
 */
function navigateToPage(page) {
  // Nos aseguramos de que la página sea un entero
  page = parseInt(page);

  console.log("Navegando a la página: ");
  console.log(page);

  // Limpiar el contenido actual de la página
  // TODO: Debería haber una animación de carga entre páginas
  showContent();
  $("#scorm-content").html("");

  // * Oculta páginas de finalización
  hideFinishedMessage();

  // * Oculta footer en caso de de no ser la primera página
  hideFooter();

  // Eliminamos el backdrop de las modales
  $(".modal-backdrop").remove();

  // Oculta los titulos de los nodos de los botones de navegación
  $(".button-node-title").hide();

  // Ocultar los botones de navegación
  $(".previous-button-link").hide();
  $(".next-button-link").hide();
  $(".finish-button-link").hide();
  hideNavigation()

  // Oculta los botones de navegación del encabezado
  $("#node-header .nav-buttons-menu .previous-button-menu-link").hide();
  $("#node-header .nav-buttons-menu .next-button-menu-link").hide();

  // Oculta el pie de pagina (footer)
  $("#node-footer").hide();

  // Obtenemos la información de la página actual
  var currentPage = contentInfo.units[page - 1];

  console.log("Información de la página: ");
  console.log(currentPage);

  // Enviar página actual al LRS
  // Si en la página actual también se carga el primer hijo, se envía el índice del mismo
  // TODO: Enviar la página en la que estaba el usuario
  if (tincan) {
    tincan.sendStatement({
      verb: {
        id: "http://adlnet.gov/expapi/verbs/progressed",
        display: {
          "en-US": "progressed to " + page,
        },
      },
      context: {
        extensions: {
          "http://id.tincanapi.com/extension/ending-point":
            !currentPage.loadFirstChild || currentPage.childs.length == 0
              ? page
              : page + 1,
        },
      },
    });
  } // Si no es TinCan y no tiene paginación
  else {
    if(typeof scorm !== 'undefined'){
      scorm.SetLessonLocation(page);
    }
    // Si no son píldoras TinCan, se comprueba el tipo de píldora y se guarda el estado
    else if (scormAPI) {
      /*if (contentInfo.has_pagination == 0){
        var status = scormAPI.LMSSetValue("cmi.core.lesson_status", "completed");
      }
      else{*/
        scormAPI.LMSSetValue("cmi.core.lesson_location", page);
      //}
      scormAPI.LMSCommit("");
    } else if (scormAPI2004) {
      /*if (contentInfo.has_pagination == 0){
        var status = scormAPI2004.SetValue("cmi.completion_status", "completed");
      }
      else{*/
        scormAPI2004.SetValue("cmi.location", page);
      //}
      scormAPI2004.Commit("");
    }
  }

  // Cargar el contenido de la página
  console.log("Cargando el contenido de la página...");
  $("#scorm-content").load(currentPage.url, function () {
    console.log("Contenido cargado correctamente.");

    console.log("Inicializar actividad de la página.");

    // TODO: Permitir tener varias actividades en la misma página
    var exe_activity = {
      interactive_video: "interactive_video/interactive-video.js",
    };

    // Cargamos el common.js
    $.getScript("js/common.js");

    // Si es una de las actividades añadidas del eXe
    if (currentPage.activities[0] in exe_activity) {
      $.getScript(exe_activity[currentPage.activities[0]]);
      // Forzamos el evento resize para adaptarnos al nuevo contenido
      $(window).trigger("resize");
    } else {
      //Si es una actividad JSON
      baseActivity.init(currentPage.activities[0]);
    }

    console.log("Actividad inicializada.");

    // Inicializar el PopOver al pasar por encima de las imágenes
    initPopover();

    // Muestra footer
    if ($("#node-footer").hasClass("footer_visible")) {
      $("#node-footer").show();
    }

    // Muestra el div botones navegación en caso de que se haya seleccionado en propiedades
    if (contentInfo.has_pagination == 1) {
      showNavigation();
    }

    // Añade la clase al elemento del listado que corresponde con el nodo actual en el menú de navegación
    $(".menu-index-display ul.list-nodes li").removeClass("selected");
    $(".menu-index-display ul.list-nodes li.node-" + (page - 1)).addClass(
      "selected"
    );

    // Añade la página actual al apartado de botones de navegación del encabezado
    $(".nav-buttons-menu .page-display .current-page").html(page);
    $(".nav-buttons-menu .page-display .total-page").html(
      contentInfo.units.length
    );

    // Si se indica que se debe mostrar el contenido del primer hijo en esta página
    if (currentPage.loadFirstChild && currentPage.childs.length > 0) {
      var childPage = contentInfo.units[currentPage.childs[0]];

      $("#scorm-content").append('<div id="child-scorm-content"></div>');

      // TODO: Hacer que se pueda poner load-first-child al hijo también
      $("#child-scorm-content").load(childPage.url, function () {
        console.log("Contenido hijo cargado correctamente.");

        console.log("Inicializar actividad de la página hija.");
        // TODO: Permitir tener varias actividades en la misma página
        // TODO: Esto debería ser asíncrono
        baseActivity.init(childPage.activities[0]);
        console.log("Actividad de la página hija inicializada.");

        // ??
        //masinfo();

        // Inicializar el PopOver al pasar por encima de las imágenes
        initPopover();
      });
    }

    // Oculta el botón siguiente si existe el botón "Comenzar"
    if($('.button-start').length){
      $('.next-button-link').hide();
    }


    // Oculta botón "Comenzar" si existe si sólo hay una página
    if(!$('.finish-button-link').is(':hidden') && $('.button-start').length){
      $('.button-start').hide();
    }


  });

  // Botones de navegación
  // Botón anterior (Solo se muestra si no es la primera página)
  // TODO: Quizás debería aparecer también en la primera página?
  if (page > 1) {
    $(".previous-button-link").show();
    $("#node-header .nav-buttons-menu .previous-button-menu-link").show();
    let previous_node = null;
    if (
      currentPage.parent === false ||
      !contentInfo.units[currentPage.parent].loadFirstChild ||
      contentInfo.units[currentPage.parent].childs[0] != page - 2
    ) {
      previous_node = contentInfo.units[page - 2];
      $(".previous-button-link").attr("href", "#page/" + (page - 1));
      $("#node-header .nav-buttons-menu .previous-button-menu-link").attr(
        "href",
        "#page/" + (page - 1)
      );
    } else {
      previous_node = contentInfo.units[page - 3];
      $(".previous-button-link").attr("href", "#page/" + (page - 2));
      $("#node-header .nav-buttons-menu .previous-button-menu-link").attr(
        "href",
        "#page/" + (page - 2)
      );
    }
    // Título del nodo previo
    let button_node_title_previous = $(".button-node-title.previous");
    if (button_node_title_previous.hasClass("button_title_visible")) {
      if (contentInfo.has_menu_numeration == 1) {
        button_node_title_previous.html(previous_node.indexstr + " " + previous_node.name);
      } else {
        button_node_title_previous.html(previous_node.name);
      }
      button_node_title_previous.attr("title", previous_node.indexstr + " " + previous_node.name);
      button_node_title_previous.show();
    }
  } else {
    $(".previous-button-link").hide();
    $("#node-header .nav-buttons-menu .previous-button-menu-link").hide();
  }
  // Botón siguiente (Aparece siempre que no sea la última página)
  // También aparece el botón siguiente si se está mostrando el primer hijo de la página actual y este es la última página
  if (
    ((!currentPage.loadFirstChild || currentPage.childs.length == 0) &&
      contentInfo.units[page]) ||
    (currentPage.loadFirstChild &&
      currentPage.childs.length > 0 &&
      contentInfo.units[page + 1])
  ) {
    $(".next-button-link").show();
    $("#node-header .nav-buttons-menu .next-button-menu-link").show();

    // Si se está mostrando el primer hijo, tenemos que saltarnos una página
    let next_node = null;
    if (!currentPage.loadFirstChild || currentPage.childs.length == 0) {
      next_node = contentInfo.units[page];
      $(".next-button-link").attr("href", "#page/" + (page + 1));
      $("#node-header .nav-buttons-menu .next-button-menu-link").attr(
        "href",
        "#page/" + (page + 1)
      );
    } else {
      next_node = contentInfo.units[page + 1];
      $(".next-button-link").attr("href", "#page/" + (page + 2));
      $("#node-header .nav-buttons-menu .next-button-menu-link").attr(
        "href",
        "#page/" + (page + 2)
      );
    }
    // Título del siguiente nodo
    let button_node_title_previous = $(".button-node-title.next");
    if (button_node_title_previous.hasClass("button_title_visible")) {
      if (contentInfo.has_menu_numeration == 1) {
        button_node_title_previous.html(next_node.indexstr + " " + next_node.name);
      } else {
        button_node_title_previous.html(next_node.name);
      }
      button_node_title_previous.attr("title", next_node.indexstr + " " + next_node.name);
      button_node_title_previous.show();
    }
    // Botón finalizar (Aparece solo en la última página)
  } else {
    $(".finish-button-link").show();
    // Título vacio
    if ($(".button-node-title.finish").hasClass("button_title_visible")) {
      $(".button-node-title.finish").show();
    }
    $(".finish-button-link").off("click");
    // Añadimos el callback para mostrar la página de finalización
    $(".finish-button-link").on("click", function (e) {
      try {
        e.preventDefault();
        // Si tiene paginación y es Scorm al pulsar en finalizar se hace el commit
        // SCORM + Paginación
        if (
          typeof scormAPI !== "undefined" ||
          typeof scormAPI2004 !== "undefined"
        ) {
          if (contentInfo.has_pagination == 1) {
            if (scormAPI) {
              var status = scormAPI.LMSSetValue(
                "cmi.core.lesson_status",
                "completed"
              );
              scormAPI.LMSCommit("");
              scormAPI.LMSFinish("");
            } else if (scormAPI2004) {
              var status = scormAPI2004.SetValue(
                "cmi.completion_status",
                "completed"
              );
              scormAPI2004.Commit("");
              scormAPI2004.Terminate("");
            }
            hideNavigation();
            hideContent();
            showFinishedMessage();
          }
        }
        // eHabilis Corporate
        else if (parent !== null && typeof parent.callbackUrl !== "undefined") {
          $("#endCallback").prop("action", parent.callbackUrl).submit();
        }
        // Píldora HTML5 | TinCan (xAPI) en caso de de abrirse en una ventana
        else if (
          document.querySelector("body").classList.contains("pildora-web") ||
          document.querySelector("body").classList.contains("tincan")
        ) {
          hideContent();
          hideNavigation();
          showFinishedMessage();
          if (tincan) {
            sendTincanFinished();
          }
        }
      } catch (error) {
        if (tincan) {
          sendTincanFinished();
        }
        hideContent();
        hideNavigation();
        showFinishedMessage();
        console.error("App catch cross origin error", error);
      }
    });
  }

  // Añade porcentaje a la barra de progreso
  data = page;
  maxValue = contentInfo.units.length;

  var completionStatus = Math.floor(data / maxValue * 100);

  // Asi nunca pasa del 100%
  if(completionStatus > 100){
      completionStatus = 100;
  }

  if(completionStatus == 100){
    $('#progress-bar-container').addClass('completo');
  }

  var currentValue = $('#progress-bar-container .barra-progreso').attr('aria-valuenow');

  if(currentValue < completionStatus){
    $('#progress-bar-container .barra-progreso').attr('aria-valuenow', completionStatus);
    $('#progress-bar-container .barra-progreso').css('width', completionStatus + '%');
    $('#progress-bar-container .valor-progreso').text(completionStatus + '%');
  }

  // Se guarda la última página
  lastPage = page;


  // Si se está mostrando el hijo del elemento actual, enviamos la página del hijo
  if (!currentPage.loadFirstChild || currentPage.childs.length == 0) {
    navigationDone(page);
  } else {
    navigationDone(page + 1);
  }
}

/**
 * Popover imágenes // galería
 **/
function initPopover() {
  // Inicializamos el popOver comprobando antes si hay alguna imagen
  if (
    $("img, .pop").length > 0 &&
    $("img, .pop").not(".exclude-popover").length > 0
  ) {
    $("img, .pop")
      .not(".exclude-popover")
      .popover({
        // Posición del PopOver en relación a la imagen
        placement: "auto",
        // Evento que se usará para mostrar el PopOver
        trigger: "hover",
        // Función que obtiene el texto (Por defecto se saca de data-content)
        content: function () {
          return $(this).prop("alt");
        },
      });
  }
}

/**
 * Buscar imágenes con la clase "img-zoom" y añadirles un wraper y un botón con un evento asociado
 * para mostrarlas en grande
 */
function processZoomImages() {
  // Añadimos el wrapper y el botón a las imágenes
  $(".img-zoom").each(function (key, img) {
    $(this)
      .wrap('<div class="img-zoom-processed"></div>')
      .before('<a href="#" class="img-zoom-link">AMPLIAR IMAGEN</a>');
  });

  // Asociamos el evento click al botón
  $(".img-zoom-link").on("click", imageZoom);
}

/**
 * Función recursiva para cargar la información de cada una de las páginas
 */
function loadUnits(units, parent, level) {
  var localUnits = [];

  parent = typeof parent == "undefined" ? false : parent;
  level = typeof level == "undefined" ? 0 : level;

  $(units).each(function (key, data) {
    // Componemos el objeto "unidad"
    var unit = {
      index:
        parent === false
          ? localUnits.length
          : localUnits.length + parent + level,
      name: $(data).children("name").text(),
      type: $(data).children("type").text(),
      url: $(data).children("url").text(),
      loadFirstChild:
        $(data).children("load-first-child") &&
        $(data).children("load-first-child").text() == "true",
      activities: [],
      childs: [],
      parent: parent,
    };

    // Si hay alguna actividad
    if ($(data).children("activities")) {
      // Las recorremos todas
      $(data)
        .children("activities")
        .children("activity")
        .each(function (activityKey, activityData) {
          // Y las añadimos a la unidad
          var activity = $(activityData).text();
          unit.activities.push(activity);
          // Obtiene los atributos del cuestionario, si exiten
          if(typeof $(activityData).attr('id') !== 'undefined'){
            unit.activities.push($(activityData).attr('id'));
          }

          if(typeof $(activityData).attr('condition') !== 'undefined'){
            unit.activities.push($(activityData).attr('condition'));
          }
        });
    }

    // Añadimos la unidad al objeto con la información de la píldora
    localUnits.push(unit);

    if ($(data).children("childs")) {
      var parentKey =
        parent === false
          ? localUnits.length - 1
          : localUnits.length + parent - 1;

      var children = loadUnits(
        $(data).children("childs").children("unit"),
        parentKey,
        level + 1
      );
      for (var i = 0; i < children.length; i++) {
        localUnits[localUnits.length - 1].childs.push(children[i].index);
      }
      localUnits = localUnits.concat(children);
    }
  });

  return localUnits;
}

/**
 * Función que devuelve una palabra aleatoria a partir de un array de palabras
 *
 */
function random_acierto() {
  var palabras = [
    $ehabilis_custom_texts.custom_text_idevice_msg_success_1,
    $ehabilis_custom_texts.custom_text_idevice_msg_success_2,
    $ehabilis_custom_texts.custom_text_idevice_msg_success_3,
    $ehabilis_custom_texts.custom_text_idevice_msg_success_4,
    $ehabilis_custom_texts.custom_text_idevice_msg_success_5,
  ];

  return palabras[Math.floor(Math.random() * (palabras.length - 1) + 0)];
}

/**
 * Función que devuelve una palabra aleatoria a partir de un array de palabras
 *
 */
function random_fallos() {
  var palabras = [
    $ehabilis_custom_texts.custom_text_idevice_msg_fail_1,
    $ehabilis_custom_texts.custom_text_idevice_msg_fail_2,
    $ehabilis_custom_texts.custom_text_idevice_msg_fail_3,
    $ehabilis_custom_texts.custom_text_idevice_msg_fail_4,
    $ehabilis_custom_texts.custom_text_idevice_msg_fail_5,
  ];

  return palabras[Math.floor(Math.random() * (palabras.length - 1) + 0)];
}

(function ($) {
  /**
   * Añadir la función "shuffle" a jQuery
   * Ordena aleatoriamente una lista de elementos
   */
  $.fn.shuffle = function () {
    var allElems = this.get(),
      getRandom = function (max) {
        return Math.floor(Math.random() * max);
      },
      shuffled = $.map(allElems, function () {
        var random = getRandom(allElems.length),
          randEl = $(allElems[random]).clone(true)[0];
        allElems.splice(random, 1);
        return randEl;
      });

    this.each(function (i) {
      $(this).replaceWith($(shuffled[i]));
    });

    return $(shuffled);
  };

  /**
   * Añadir la función "shuffleArray" a jQuery
   * Ordena aleatoriamente un array JS
   *
   * @param keep_first Si es true, se mantendrá el primer elemento del array
   */
  $.fn.shuffleArray = function (keep_first) {
    let last_element = typeof keep_first != "undefined" && keep_first ? 1 : 0;

    var array = this.get();

    for (var i = array.length - 1; i > last_element; i--) {
      var j = Math.floor(Math.random() * (i + 1));
      var temp = array[i];
      array[i] = array[j];
      array[j] = temp;
    }
    return array;
  };
})(jQuery);

/**
 * Corrige la posición de las ventanas modales cuando están dentro de un IFrame
 *
 * @param e El evento bs.modal.show que ha llamado a esta función
 */
function fixModalPosition(e) {
  var in_iframe = false;

  // Comprobamos si estamos en un IFrame
  try {
    in_iframe = window.self !== window.top;
  } catch (exception) {
    // Puede fallar por "Same-origin policy"
    in_iframe = true;
  }

  // Solo si está dentro de un IFrame
  // Cuando no está en un IFrame Bootstrap hace el cálculo correctamente
  if (in_iframe) {
    var top_scroll_position = window.top.scrollY;

    // Si recibimos el aviso del método shown comprobamos que no se haya salido fuera de la pantalla
    if (
      typeof e.data != "undefined" &&
      typeof e.data.visible != "undefined" &&
      e.data.visible
    ) {
      // Obtenemos la altura todal del IFrame y de la modal
      var iframe_height = $("body").outerHeight();
      var modal_height = $(this).find(".modal-dialog").outerHeight(true);

      // Si la modal se va a salir del IFrame, establecemos la altura a
      // la altura del IFrame menos la altura de la modal (menos 20px para
      // que no salga pegado al borde)
      if (top_scroll_position + modal_height >= iframe_height) {
        top_scroll_position = iframe_height - modal_height - 20;
      }
    }

    // Si es menor que 0
    if (top_scroll_position < 0) {
      top_scroll_position = 0;
    }

    // Establecemos la posición
    $(this).css("top", top_scroll_position);

    // Para ajustar el tamaño del iframe una vez que se abre la ventana modal
    $(window).trigger("resize");
  }
}

/**
 * Función funcionalidad botón más info (??)
 **/
function masinfo() {
  $(".fa-sort-amount-asc").removeClass("on");
  $(".fa-sort-amount-asc").off("click");

  $(".fa-sort-amount-asc").on("click", function (e) {
    if ($(this).hasClass("on")) {
      $(this).removeClass("on");
    } else {
      $(this).addClass("on");
    }
    $(".mas_info").toggle();
    $(window).trigger("resize");
  });
  if (!$(".mas_info").length) {
    $(".fa-sort-amount-asc").hide();
  } else {
    $(".fa-sort-amount-asc").show();
  }
}

/**
 *
 * Script para inicializar el chroma_video
 *
 **/
function chroma_video(fondo, target) {
  var seriously;
  var fondo;
  var target;
  var chroma;

  seriously = new Seriously();
  fondo = seriously.source(fondo);
  target = seriously.target(target);
  chroma = seriously.effect("chroma");
  chroma.source = fondo;
  chroma.screen = "rgb(77, 239, 41)";
  chroma.balance = 0;
  chroma.weight = 1.32;
  chroma.clipWhite = 0.85;
  chroma.clipBlack = 0.5125;
  target.source = chroma;
  seriously.go();
}

/**
 *
 * Función para inicializar una galería definida en json_recursos/galeria.json
 *
 **/
/*function galeria_imagenes() {
    $('#galeria_img').on('show.bs.modal', function() {
        $('#galeria_img').find('.modal-body').html('');
        $('#galeria_img').find('.modal-body').append('<div class="galeria row"></div>');
        $.getJSON('json_recursos/galeria.json', function(data) {
            $.each(data, function(key, val) {
                if ($.isEmptyObject(data)) {
                    $('.galeria').hide();
                };
                $.each(val, function(key1, val1) {
                    $('#galeria_img').find('.galeria').append('<div class="border_img"><a class="fancy_gall" href="' + val1.src + '"><img class="thum_gall" src="' + val1.src + '"/></a></div>');
                })
            })
        }).fail(function() {
            console.log("error");
            $('.galeria').hide();
        });
        $('.fancy_gall').fancybox();
    });
}*/


function hideNavigation() {
  document.querySelector("#navigation-buttons").style.display = "none";
}

function showNavigation() {
  document.querySelector("#navigation-buttons").style.display = "block";
}

function hideContent() {
  document.querySelector("#scorm-content").style.display = "none";
}

function showContent() {
  document.querySelector("#scorm-content").style.display = "block";
}


/** Oculta footer en caso de no ser la primera página */
function hideFooter() {
  // * Constantes
  const nodeFooter =  $('#node-footer');
  const classAllPages = 'all_pages';

  // * Variables
  var splitElement = '/';
  var locationHash = document.location.hash;
  var locationHashArrayPosition = 1;

  // * En caso de tener la clase de la constante "classAllPages" no se ocultará el footer
  if(!nodeFooter.hasClass(classAllPages)) {
    // * Comprobamos la página en caso de que el hash tenga valor
    if(locationHash !== '') {
      // * Dividimos el hash en un array con la página y el número de ella
      var locationHashArray = document.location.hash.split(splitElement);
      // * Comprobamos que exista esa posición
      if(locationHashArray[locationHashArrayPosition]) {
        var pageNumber = locationHashArray[locationHashArrayPosition];
      } else {
        // ! En caso de no existir la posición se interpreta que está en la 1a página
        var pageNumber = 1;
      }

      // * Comprobamos el número de página y ocultamos el footer
      if (pageNumber != 1) {
        // * Creamos intervalo para detectar cuando se implementa el footer a traves del scorm
        var hideFooterInterval = setInterval(() => {
          // * Variables
          var scormContentChildren = $('#scorm-content').children();
          // * Comprobación del contenido del scorm
          if(scormContentChildren.length > 0 ) {
            nodeFooter.hide();

            // * Quitamos intervalo
            clearInterval(hideFooterInterval);
          }
        },100)
      }
    }
  }
}


function hideFinishedMessage() {
  document.querySelector("#scorm-finished-page-1").style.display = "none";
  document.querySelector("#scorm-finished-page-2").style.display = "none";
  // ! Desactiva la tercera página de finalización
  document.querySelector("#scorm-finished-page-3").style.display = "none";
}

function showFinishedMessage() {
  let hidePage1 = document.querySelector("#scorm-finished-page-1").classList.contains("finish-page-1-hide");
  let hidePage2 = document.querySelector("#scorm-finished-page-2").classList.contains("finish-page-2-hide");
  if (!hidePage1) {
    document.querySelector("#scorm-finished-page-1").style.display = "block";
  } else if (!hidePage2) {
    document.querySelector("#scorm-finished-page-2").style.display = "block";
  } else {
    // ! Desactiva la tercera página de finalización
    document.querySelector("#scorm-finished-page-3").style.display = "block";
  }
  showFinishNavigationButton();
}

function showFinishNavigationButton() {
  let hidePage1 = document.querySelector("#scorm-finished-page-1").classList.contains("finish-page-1-hide");
  let hidePage2 = document.querySelector("#scorm-finished-page-2").classList.contains("finish-page-2-hide");
  if (hidePage1 && hidePage2) {
    // ! Desactiva la tercera página de finalización
    document.querySelector("#scorm-finished-page-3 .navigation-finish").style.display = "none";
  } else if (hidePage1) {
      document.querySelector("#scorm-finished-page-2 .navigation-finish.left").style.display = "none";
  } else if (hidePage2) {
    // ! Desactiva la tercera página de finalización
    document.querySelector("#scorm-finished-page-3 .navigation-finish.left .previous-button-link-finish").setAttribute('onclick', 'showPage(event, 1)');
    document.querySelector("#scorm-finished-page-1 .navigation-finish.right .next-button-link-finish").setAttribute('onclick', 'showPage(event, 3)');
  }
}

function sendTincanFinished() {
  tincan.sendStatement({
    verb: {
      id: "http://adlnet.gov/expapi/verbs/finished",
      display: {
        "en-US": "http://adlnet.gov/expapi/verbs/finished",
      },
    }
  });
}


/**
 * Envia intento al LRS
 *
 * @param {*} attemptTime
 * @param {*} attemptSumgrades
 * @param {*} scoreToPassed
 * @param {*} idIdevice
 */
function sendTincanAttempted(attemptTime, attemptSumgrades, scoreToPassed, idIdevice, attemptedNum){
  // Envia los datos al LRS
  if(tincan){
    // Se obtiene el título del cuestionario
    let titleIdevice = '';
    let title = document.querySelector('#id' + idIdevice + ' .title-quiz-test-scorm');
    if(title){
      titleIdevice = title.innerHTML;
    }

    // Se pasa el tiempo de milisegundos a segundos
    // Se omite la duración ya que la recoge la píldora
    //attemptTime = durationToISO8601(Math.floor(attemptTime / 1000));
    attemptTime = 'P0DT0H0M0S';

    // Se añaden URL para el número de intento y el id del cuestionario
    let mainUrl = tincan.activity.id.substring(0, tincan.activity.id.indexOf('iri/'));

    let attemptUrl = mainUrl + 'extensions/quiz-attempt';
    let quizIdUrl = mainUrl + 'extensions/quiz-id';

    tincan.sendStatement({
      verb: {
        id: "http://adlnet.gov/expapi/verbs/attempted"
      },
      result: {
        score:{
          raw: attemptSumgrades,
          min: 0,
          max: 100,
          scaled: attemptSumgrades / 100
        },
        duration: attemptTime,
        extensions :{
          [attemptUrl] : parseInt(attemptedNum),
          [quizIdUrl] : parseInt(idIdevice)
        }
      },
      object:{
        objectType : tincan.activity.objectType,
        id : tincan.activity.id,
        definition:{
          name:{
            'es-ES' : titleIdevice
          }
        }
      }
    });

    // Envia los datos si ha aprobado o no
    //sendTincanStatus(attemptSumgrades, scoreToPassed, titleIdevice, idIdevice, attemptedNum);
  }
}

/**
 * Pasar un número de segundos a ISO8601 (como duración "PnYnMnDTnHnMnS")
 *
 * @param {*} seconds
 * @returns
 */
function durationToISO8601(seconds){
  var intervals = {'D' : 60*60*24, 'H': 60*60, 'M' : 60, 'S' : 1};
  // Siempre debemos añadir todos los campos (PnDTmHmNmS)
  var result = 'P';

  // Se transforma el objeto para que se pueda recorrer como un array
  Object.keys(intervals).forEach(function (key) {
    let tag = key;
    let divisor = intervals[key];

    let quantity = Math.floor(seconds / divisor);

    // Al llegar a las horas añadimos la T
    if (tag == 'H') {
      result += 'T';
    }

    seconds -= quantity * divisor;
    result  += quantity + tag;

  });

  // Si no se ha obtenido nada (Tiempo 0)
  if (result == '') {
    result = 'P0DT0H0M0S';
  }

  return result;

}

/**
 * Envia al LRS si el cuestionario está aprobado o no
 *
 * @param {*} attemptSumgrades
 * @param {*} scoreToPassed
 * @param {*} titleIdevice
 */
function sendTincanStatus(attemptSumgrades, scoreToPassed, titleIdevice, idIdevice, attemptedNum){
  let statement = '';

  let mainUrl = tincan.activity.id.substring(0, tincan.activity.id.indexOf('iri/'));

  let attemptUrl = mainUrl + 'extensions/quiz-attempt';
  let quizIdUrl = mainUrl + 'extensions/quiz-id';

  if(attemptSumgrades >= scoreToPassed){
    statement = 'http://adlnet.gov/expapi/verbs/passed';
  }
  else{
    statement = 'http://adlnet.gov/expapi/verbs/failed';
  }

  // Envia los datos al LRS
  if(tincan){
    tincan.sendStatement({
      verb: {
        id: statement
      },
      result: {
        score:{
          raw: attemptSumgrades,
          min: 0,
          max: 100,
          scaled: attemptSumgrades / 100
        },
        duration: 'P0DT0H0M0S',
        extensions :{
          [attemptUrl] : parseInt(attemptedNum),
          [quizIdUrl] : parseInt(idIdevice)
        }
      },
      object:{
        objectType : tincan.activity.objectType,
        id : tincan.activity.id,
        definition:{
          name:{
            'es-ES' : titleIdevice
          }
        }
      }
    });
  }

}
