/**
 * platform.js
 * Funciones relativas a la plataforma de eHabilis
 */

/**
 * Con esta función controlamos la redimensión de la ventana
 **/
function handleResize(e, doScroll) {
    doScroll = (typeof doScroll !== 'undefined') ? doScroll: false;

    // Enviamos el alto a la ventana padre
    var modal_height = $('body').find('.modal-dialog').outerHeight(true);
    var body_height = $("body").height();
    // Si el tamaño de la ventana modal es mayor que la del body
    if(body_height < modal_height){
        // Se envia el tamaño que resta hasta el tamaño de la modal
        var size_total = body_height + (modal_height - body_height);
        sendHeight(size_total, ((doScroll) ? 1: 0));
    }
    else{
        sendHeight(body_height, ((doScroll) ? 1: 0));
    }
}

/**
 * Envía el tamaño del body a la pagina padre (cuando la píldora está en iframe)
 *
 * @param height: Alto a enviar
 * @param doScroll:
 *	0 - no mover scroll actual después de redimensionar
 *	1 - mover scroll a 0,0 después de redimensionar
 *
 */
function sendHeight(height, doScroll) {
    // Intentamos enviar el alto al padre
    try {
	    parent.postMessage('alto:' + height + '|scroll:' + doScroll, location.protocol + '//' + location.host);
    } catch(e) {
        console.log('[ERROR] No se ha podido enviar el alto a la página padre.');
    }
}

/**
 * Muestra una ventana modal con la imagen en grande (Esta parte solo llama al portal)
 *
 * TODO: Hacer que llame a Fancybox si no se llama al portal
 *
 * @param e Datos sobre el evento (click)
 */
function imageZoom(e) {
    e.preventDefault();

    // Obtenemos la imagen
    var image = $(this).siblings('.img-zoom')[0];
    // Obtenemos los datos de la imagen
    var options = { width: image.naturalWidth, height: image.naturalHeight };

    // Llamamos a la función del padre
    try {
        parent.showModal($(image).prop('src'), 'image', options);
    } catch(e) {
        console.log('[ERROR] No se ha podido mostrar la imagen en grande.');
    }
}

function navigationDone(page) {
    // Intentamos enviar el alto al padre
    try {
	    parent.postMessage('page:' + page, location.protocol + '//' + location.host);
    } catch(e) {
        console.log('[ERROR] No se ha podido enviar la notificación de navegación al padre.');
    }
}